package com.cku.oa.dog.web;

import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogSecondBreeder;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogSecondBreederService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 第二繁殖人Controller
 * @author wj
 * @version 2020-08-13
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogSecondBreeder")
public class DogSecondBreederController extends BaseController {

	@Autowired
	private DogSecondBreederService dogSecondBreederService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;


	@ModelAttribute
	public DogSecondBreeder get(@RequestParam(required=false) String id) {
		DogSecondBreeder entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogSecondBreederService.get(id);
		}
		if (entity == null){
			entity = new DogSecondBreeder();
		}
		return entity;
	}

	@RequiresPermissions("dog:dogSecondBreeder:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogSecondBreeder dogSecondBreeder, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogSecondBreeder> page = dogSecondBreederService.findPage(new Page<DogSecondBreeder>(request, response), dogSecondBreeder);
		model.addAttribute("page", page);
		return "oa/dog/dogSecondBreeder/dogSecondBreederList";
	}

	@RequiresPermissions("dog:dogSecondBreeder:view")
	@RequestMapping(value = "form")
	public String form(DogSecondBreeder dogSecondBreeder, Model model) {

		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findByFmdogBreedCertifiedCode(dogSecondBreeder.getBreedCertifiedCode());
		dogBirthCertificateList.stream().map(data->{
			data.setDogBreed(dogTypeService.getByDogBreedCode(data.getDogBreed()).getBreedCnName());
			return data;
		}).collect(Collectors.toList());
		Member member = memberDao.getByMemberCode(dogSecondBreeder.getSecondBreederMemberCode());
		model.addAttribute("dogSecondBreeder", dogSecondBreeder);
		if(member.getMemberEndDate() != null  && member.getMemberEndDate().getTime() >= new Date().getTime()){
			member.setStates("1");
		}else{
			member.setStates("0");
		}
		model.addAttribute("member", member);
		model.addAttribute("dogBirthCertificateList", dogBirthCertificateList);
		return "oa/dog/dogSecondBreeder/dogSecondBreederForm";
	}
	@RequiresPermissions("dog:dogSecondBreeder:review")
	@RequestMapping(value = "review")
	public String review(DogSecondBreeder dogSecondBreeder, Model model) {
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findByFmdogBreedCertifiedCode(dogSecondBreeder.getBreedCertifiedCode());
		dogBirthCertificateList.stream().map(data->{
			data.setDogBreed(dogTypeService.getByDogBreedCode(data.getDogBreed()).getBreedCnName());
			return data;
		}).collect(Collectors.toList());
		Member member = memberDao.getByMemberCode(dogSecondBreeder.getSecondBreederMemberCode());
		if(member.getMemberEndDate() != null  && member.getMemberEndDate().getTime() >= new Date().getTime()){
			member.setStates("1");
		}else{
			member.setStates("0");
		}
		model.addAttribute("dogSecondBreeder", dogSecondBreeder);
		model.addAttribute("member", member);
		model.addAttribute("dogBirthCertificateList", dogBirthCertificateList);
		return "oa/dog/dogSecondBreeder/dogSecondBreederEditForm";
	}
	@RequiresPermissions("dog:dogSecondBreeder:review")
	@RequestMapping(value = "process")
	public String process(DogSecondBreeder dogSecondBreeder, Model model,RedirectAttributes redirectAttributes) {
		try {
			dogSecondBreederService.process(dogSecondBreeder);
		} catch (Exception e) {
			logger.warn("第二繁殖人处理出错", e);
			addMessage(redirectAttributes, "第二繁殖人处理出错:" + e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/dog/dogSecondBreeder/?repage";
	}
	@RequestMapping(value = "saveReview")
	public String saveReview(DogSecondBreeder dogSecondBreeder, Model model,RedirectAttributes redirectAttributes) {
		dogSecondBreederService.review(dogSecondBreeder);
		return "redirect:"+Global.getAdminPath()+"/dog/dogSecondBreeder/?repage";
	}

	@RequestMapping(value = "getSecondBreeder")
	@ResponseBody
	public Object checkSecondBreeder(String secondBreederMemberCode) {
		Map<String,Object> map = new HashMap<String,Object>();
		try {
			map = dogSecondBreederService.getSecondBreeder(secondBreederMemberCode);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequestMapping(value = "findByFmdogBreedCertifiedCode")
	@ResponseBody
	public Object findByFmdogBreedCertifiedCode(@RequestParam(required = true) String fmdogBreedCertifiedCode) {
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateService.findByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
		dogBirthCertificateList.stream().map(data->{
			data.setDogBreed(dogTypeService.getByDogBreedCode(data.getDogBreed()).getBreedCnName());
			if(StringUtils.isBlank(data.getPedigreeCertified())){
				data.setPedigreeCertified("");
			}
			if(StringUtils.isBlank(data.getSecondBreederMemberCode())){
				data.setSecondBreederMemberCode("");
			}
			return data;
		}).collect(Collectors.toList());
		return dogBirthCertificateList;
	}
	@RequiresPermissions("dog:dogSecondBreeder:edit")
	@RequestMapping(value = "save")
	public String save(DogSecondBreeder dogSecondBreeder, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogSecondBreeder)){
			return form(dogSecondBreeder, model);
		}
		dogSecondBreederService.save(dogSecondBreeder);
		addMessage(redirectAttributes, "保存第二繁殖人成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogSecondBreeder/?repage";
	}

	@RequiresPermissions("dog:dogSecondBreeder:edit")
	@RequestMapping(value = "delete")
	public String delete(DogSecondBreeder dogSecondBreeder, RedirectAttributes redirectAttributes) {
		dogSecondBreederService.delete(dogSecondBreeder);
		addMessage(redirectAttributes, "删除第二繁殖人成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogSecondBreeder/?repage";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogSecondBreeder dogSecondBreeder, Model model) {
		List<DogSecondBreeder> list = dogSecondBreederService.findList(dogSecondBreeder);
		model.addAttribute("list", list);
		return "oa/dog/dogSecondBreeder/dogSecondBreederOrderList";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(String  runningNumber,Model model) {
		model.addAttribute("runningNumber", runningNumber);
		return "oa/dog/dogSecondBreeder/dogSecondBreederOrderAdd";
	}
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "saveOrder")
	@ResponseBody
	public Object saveOrder(DogSecondBreeder dogSecondBreeder) {
		HashMap<String,String> map = new HashMap<String,String>();
		map.put("rc", "0");
		try {
			dogSecondBreederService.saveOrder(dogSecondBreeder);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

}