package com.cku.oa.dog.web;

import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogFrozenSemen;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogFrozenSemenService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 犬只冷冻精子Controller
 *
 * @author lgl
 * @version 2017-08-24
 */
@Controller
@RequestMapping(value = "${adminPath}/dogfrozensemen/dogFrozenSemen")
public class DogFrozenSemenController extends BaseController {

    @Autowired
    private DogFrozenSemenService dogFrozenSemenService;
    @Autowired
    private DogDao dogDao;
    @Autowired
    private DogSemenDao dogSemenDao;

    private final static String AUTHORITY_PRDFIX = "dogfrozensemen:dogFrozenSemen:";

    @ModelAttribute
    public DogFrozenSemen get(@RequestParam(required = false) String id) {
        DogFrozenSemen entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogFrozenSemenService.get(id);
        }
        if (entity == null) {
            entity = new DogFrozenSemen();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogFrozenSemen dogFrozenSemen, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogFrozenSemen> page = dogFrozenSemenService.findPage(new Page<DogFrozenSemen>(request, response), dogFrozenSemen);
        model.addAttribute("page", page);
        return "oa/dog/dogfrozensemen/dogFrozenSemen" + dogFrozenSemen.getBusinessType() + "List";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        model.addAttribute("dogSemenList", dogSemenList);
        return "oa/dog/dogfrozensemen/dogFrozenSemenForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit0Form")
    public String audit0Form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        return "oa/dog/dogfrozensemen/dogFrozenSemenAudit0Form";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit1Form")
    public String audit1Form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        model.addAttribute("dogSemenList", dogSemenList);
        return "oa/dog/dogfrozensemen/dogFrozenSemenAudit1Form";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit0Form")
    public String edit0Form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        model.addAttribute("dogSemenList", dogSemenList);
        model.addAttribute("dogSemenListSize", dogSemenList.size());
        return "oa/dog/dogfrozensemen/dogFrozenSemenEdit0Form";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit1Form")
    public String edit1Form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        model.addAttribute("dogSemenList", dogSemenList);
        model.addAttribute("dogSemenListSize", dogSemenList.size());
        return "oa/dog/dogfrozensemen/dogFrozenSemenEdit1Form";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit0")
    public String audit0(DogFrozenSemen po, RedirectAttributes redirectAttributes) {
        dogFrozenSemenService.audit0(po);
        addMessage(redirectAttributes, "种犬申报审核成功");
        return repage(po);
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit1")
    public String audit1(DogFrozenSemen po, RedirectAttributes redirectAttributes) {
        dogFrozenSemenService.audit1(po);
        addMessage(redirectAttributes, "种犬报备审核成功");
        return repage(po);
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit0")
    public String edit0(DogFrozenSemen po, RedirectAttributes redirectAttributes) {
        dogFrozenSemenService.edit0(po);
        addMessage(redirectAttributes, "种犬申报编辑成功");
        return repage(po);
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit1")
    public String edit1(DogFrozenSemen po, RedirectAttributes redirectAttributes) {
        dogFrozenSemenService.edit1(po);
        addMessage(redirectAttributes, "种犬报备编辑成功");
        return repage(po);
    }

    private String repage(DogFrozenSemen po) {
        return "redirect:" + Global.getAdminPath() + "/dogfrozensemen/dogFrozenSemen/list?businessType=" + po.getBusinessType();
    }
}