package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;

/**
 * 语言Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/language")
public class LanguageController extends BaseController {

	@Autowired
	private LanguageService languageService;
	
	@ModelAttribute
	public Language get(@RequestParam(required=false) String id) {
		Language entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = languageService.get(id);
		}
		if (entity == null){
			entity = new Language();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:language:view")
	@RequestMapping(value = {"list", ""})
	public String list(Language language, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Language> page = languageService.findPage(new Page<Language>(request, response), language); 
		model.addAttribute("page", page);
		return "oa/contest/languageList";
	}

	@RequiresPermissions("contest:language:view")
	@RequestMapping(value = "form")
	public String form(Language language, Model model) {
		model.addAttribute("language", language);
		return "oa/contest/languageForm";
	}

	@RequiresPermissions("contest:language:edit")
	@RequestMapping(value = "save")
	public String save(Language language, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, language)){
			return form(language, model);
		}
		languageService.save(language);
		addMessage(redirectAttributes, "保存语言成功");
		return "redirect:"+Global.getAdminPath()+"/contest/language/?repage";
	}
	
	@RequiresPermissions("contest:language:del")
	@RequestMapping(value = "delete")
	public String delete(Language language, RedirectAttributes redirectAttributes) {
		languageService.delete(language);
		addMessage(redirectAttributes, "删除语言成功");
		return "redirect:"+Global.getAdminPath()+"/contest/language/?repage";
	}

}