package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestCritic;
import com.cku.oa.contest.service.ContestCriticService;

/**
 * 犬展犬只部位评价Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestCritic")
public class ContestCriticController extends BaseController {

	@Autowired
	private ContestCriticService contestCriticService;
	@Autowired
	private LanguageService languageService;
	
	@ModelAttribute
	public ContestCritic get(@RequestParam(required=false) String id) {
		ContestCritic entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestCriticService.get(id);
		}
		if (entity == null){
			entity = new ContestCritic();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestCritic:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestCritic contestCritic, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestCritic> page = contestCriticService.findPage(new Page<>(request, response), contestCritic);
		model.addAttribute("page", page);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestCriticList";
	}

	@RequiresPermissions("contest:contestCritic:view")
	@RequestMapping(value = "form")
	public String form(ContestCritic contestCritic, Model model) {
		model.addAttribute("contestCritic", contestCritic);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestCriticForm";
	}

	@RequiresPermissions("contest:contestCritic:edit")
	@RequestMapping(value = "save")
	public String save(ContestCritic contestCritic, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestCritic)){
			return form(contestCritic, model);
		}
		contestCriticService.save(contestCritic);
		addMessage(redirectAttributes, "保存犬展犬只部位评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestCritic/?repage";
	}
	
	@RequiresPermissions("contest:contestCritic:del")
	@RequestMapping(value = "delete")
	public String delete(ContestCritic contestCritic, RedirectAttributes redirectAttributes) {
		contestCriticService.delete(contestCritic);
		addMessage(redirectAttributes, "删除犬展犬只部位评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestCritic/?repage";
	}

}