package com.cku.oa.components.rule.validation.member;

import java.util.Calendar;
import java.util.Date;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberType;
import org.springframework.stereotype.Component;

/**
 * 会员的条件判断
 * @author fanhuibin
 *
 */
@Component
public class MemberCondition {
	/**
	 * 判断一个用户是否为基础类型用户
	 * @param member
	 * @return
	 */
	public  boolean isBasicMember(Member member) {
		if(member!=null && member.getMemberType().equals(MemberType.basic.toString())){
			return true;
		}
		
		if(member!=null && (member.getMemberType() == null || member.getMemberType().equals(""))){
			return true;
		}
		
		return false;
	}
	
	/**
	 * 判断一个用户是否为专业版的用户
	 * @param member
	 * @return
	 */
	public  boolean isProfessionalMember(Member member) {
		Date currentDate = new Date();
		
		if(member!=null && member.getMemberType().equals(MemberType.professional.toString())){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断当前一个用户是否为有效的会员或者有效的美容师会员
	 * @param member
	 * @return
	 */
	public  boolean isActiveMemberOrGroomer(Member member) {
		Calendar calendar = Calendar.getInstance();  
        calendar.setTime(new Date());  
        calendar.add(Calendar.DAY_OF_MONTH, -1);  
        Date  currentDate = calendar.getTime(); 
		//美容师会员没有过期，但是会员过期的，默认算是基础会员，享有基础会员的基本功能
		if(member!=null && member.getGroomerEndDate()!= null && member.getGroomerEndDate().getTime()>currentDate.getTime()){
			return true;
		}
		
		if(member!=null &&member.getPaymentState() != null && member.getPaymentState().equals("2")){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断当前一个用户是否为有效的会员
	 * @param member
	 * @return
	 */
	public boolean isActiveMember(Member member) {
		if(member.getMemberEndDate() != null && member.getMemberEndDate().getTime() > System.currentTimeMillis()){
			return true;
		}else {
			return false;
		}
	}
	
	/**
	 * 判断当前一个用户是有效美容师
	 * @param member
	 * @return
	 */
	public boolean isActiveGroomer(Member member) {
		if(member.getGroomerEndDate() != null && member.getGroomerEndDate().getTime() > System.currentTimeMillis()){
			return true;
		}else{
			return false;
		}
	}
}
