/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.clubdog.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 淘宠宝犬只信息Entity
 * @author cxt
 * @version 2017-10-12
 */
public class ClubDog extends DataEntity<ClubDog> {
	
	private static final long serialVersionUID = 1L;
	private String pedigreeCertifiedCode;		// 血统证书号
	private String dogOwner;		// 犬主人
	private String memberCode;		// 会员号
	private String nameEn;		// 英文姓名
	private String nameCn;		// 中文姓名
	private String gender;		// 性别
	private String dogBreed;		// 种类
	private Date birthdate;		// 出生日期
	private String identificationFlag;		// 身份识别标记
	private String colorFlag;		// 颜色及标志
	private String identifyer;		// 鉴定人
	private String identifyCode;		// 鉴定编号
	private Date identifyTime;		// 鉴定时间
	private String identifySite;		// 鉴定地点
	private String firstPrint;		// 首次打印标记位
	private String paymentState;		// 支付状态
	private Date paymentTime;		// 支付时间
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核备注
	private String processState;		// 处理状态
	private Date processTime;		// 处理时间
	private String printState;		// 打印状态
	private String operator;		// 操作记录
	private String runningNumber;		// 流水号
	
	public ClubDog() {
		super();
	}

	public ClubDog(String id){
		super(id);
	}

	@Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}

	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}
	
	@Length(min=0, max=64, message="犬主人长度必须介于 0 和 64 之间")
	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}
	
	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=255, message="英文姓名长度必须介于 0 和 255 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}
	
	@Length(min=0, max=10, message="性别长度必须介于 0 和 10 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}
	
	@Length(min=0, max=64, message="种类长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}
	
	@Length(min=0, max=64, message="身份识别标记长度必须介于 0 和 64 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}
	
	@Length(min=0, max=64, message="颜色及标志长度必须介于 0 和 64 之间")
	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}
	
	@Length(min=0, max=255, message="鉴定人长度必须介于 0 和 255 之间")
	public String getIdentifyer() {
		return identifyer;
	}

	public void setIdentifyer(String identifyer) {
		this.identifyer = identifyer;
	}
	
	@Length(min=0, max=255, message="鉴定编号长度必须介于 0 和 255 之间")
	public String getIdentifyCode() {
		return identifyCode;
	}

	public void setIdentifyCode(String identifyCode) {
		this.identifyCode = identifyCode;
	}
	
	@Length(min=0, max=1, message="支付状态长度必须介于 0 和 1 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@Length(min=0, max=1, message="审核状态长度必须介于 0 和 1 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=255, message="审核备注长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}
	
	@Length(min=0, max=1, message="处理状态长度必须介于 0 和 1 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}
	
	@Length(min=0, max=64, message="打印状态长度必须介于 0 和 64 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}
	
	@Length(min=0, max=1000, message="操作记录长度必须介于 0 和 1000 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	@Length(min=0, max=1000, message="流水号长度必须介于 0 和 1000 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	public Date getIdentifyTime() {
		return identifyTime;
	}

	public void setIdentifyTime(Date identifyTime) {
		this.identifyTime = identifyTime;
	}

	public String getIdentifySite() {
		return identifySite;
	}

	public void setIdentifySite(String identifySite) {
		this.identifySite = identifySite;
	}

	public String getFirstPrint() {
		return firstPrint;
	}

	public void setFirstPrint(String firstPrint) {
		this.firstPrint = firstPrint;
	}

	public String getNameCn() {
		return nameCn;
	}

	public void setNameCn(String nameCn) {
		this.nameCn = nameCn;
	}
	
}