package com.cku.oa.breeder.web;

import com.cku.oa.breeder.entity.Banner;
import com.cku.oa.breeder.service.BannerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 繁育人BannerController
 *
 * @author lgl
 * @version 2017-10-11
 */
@Controller
@RequestMapping(value = "${adminPath}/breeder/banner")
public class BannerController extends BaseController {

	@Autowired
	private BannerService bannerService;

	@ModelAttribute
	public Banner get(@RequestParam(required = false) String id) {
		Banner entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = bannerService.get(id);
		}
		if (entity == null) {
			entity = new Banner();
		}
		return entity;
	}

	@RequiresPermissions("breeder:banner:view")
	@RequestMapping(value = {"list", ""})
	public String list(Banner banner, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Banner> page = bannerService.findPage(new Page<Banner>(request, response), banner);
		model.addAttribute("page", page);
		return "oa/breeder/banner/bannerList";
	}

	@RequiresPermissions("breeder:banner:view")
	@RequestMapping(value = "form")
	public String form(Banner banner, Model model) {
		model.addAttribute("banner", banner);
		return "oa/breeder/banner/bannerForm";
	}

	@RequiresPermissions("breeder:banner:edit")
	@RequestMapping(value = "save")
	public String save(Banner banner, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, banner)) {
			return form(banner, model);
		}
		//URL地址不转意
		banner.setUrl(StringEscapeUtils.unescapeHtml4(banner.getUrl()));
		bannerService.save(banner);
		addMessage(redirectAttributes, "保存繁育人Banner成功");
		return "redirect:" + Global.getAdminPath() + "/breeder/banner/?repage";
	}

	@RequiresPermissions("breeder:banner:edit")
	@RequestMapping(value = "delete")
	public String delete(Banner banner, RedirectAttributes redirectAttributes) {
		bannerService.delete(banner);
		addMessage(redirectAttributes, "删除繁育人Banner成功");
		return "redirect:" + Global.getAdminPath() + "/breeder/banner/?repage";
	}

}