package com.cku.oa.banner.web;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.banner.entity.AppBanner;
import com.cku.oa.banner.service.AppBannerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 广告位管理Controller
 * @author zhaoxy
 * @version 2021-01-13
 */
@Controller
@RequestMapping(value = "${adminPath}/banner/appBanner")
public class AppBannerController extends BaseController {

	@Autowired
	private AppBannerService appBannerService;
	
	@ModelAttribute
	public AppBanner get(@RequestParam(required=false) String id) {
		AppBanner entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = appBannerService.get(id);
		}
		if (entity == null){
			entity = new AppBanner();
		}
		return entity;
	}
	
	@RequiresPermissions("banner:appBanner:view")
	@RequestMapping(value = {"list", ""})
	public String list(AppBanner appBanner, HttpServletRequest request, HttpServletResponse response, Model model) {
		if(appBanner.getCreateDate() != null) {
			String start = DateUtils.formatDate(appBanner.getCreateDate()) + " 00:00:00";
			appBanner.setCreateDateBegin(DateUtils.parseDate(start));
			String end = DateUtils.formatDate(appBanner.getCreateDate()) + " 23:59:59";
			appBanner.setCreateDateEnd(DateUtils.parseDate(end));
		} else {
			appBanner.setCreateDateBegin(null);
			appBanner.setCreateDateEnd(null);
		}
		Page<AppBanner> page = appBannerService.findPage(new Page<AppBanner>(request, response), appBanner); 
		model.addAttribute("page", page);
		return "oa/banner/appBannerList";
	}

	@RequiresPermissions("banner:appBanner:add")
	@RequestMapping(value = "form")
	public String form(AppBanner appBanner, Model model) {
		if (appBanner.getBannerId() != null && !appBanner.getBannerId().equals("")) {
			appBanner = appBannerService.get(appBanner.getBannerId());
			appBanner.setId(appBanner.getBannerId());
			model.addAttribute("appBanner", appBanner);
			return "oa/banner/appBannerForm";
		} else {
			model.addAttribute("appBanner", appBanner);
			return "oa/banner/appBannerAdd";
		}
	}

	@RequiresPermissions("banner:appBanner:edit")
	@RequestMapping(value = "save")
	public String save(AppBanner appBanner, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, appBanner)){
			return form(appBanner, model);
		}
		AppBanner result = appBannerService.findByParam(appBanner);
		if (result != null) {
			addMessage(redirectAttributes, "相同位置犬舍不能重复");
		}else {
			addMessage(redirectAttributes, "保存广告位成功");
			String endDate = DateUtils.formatDate(appBanner.getEndDate()) + " 23:59:59";
			appBanner.setEndDate(DateUtils.parseDate(endDate));
			appBannerService.save(appBanner);
		}
		return "redirect:"+Global.getAdminPath()+"/banner/appBanner/?repage";
	}
	
	@RequiresPermissions("banner:appBanner:edit")
	@RequestMapping(value = "delete")
	public String delete(AppBanner appBanner, RedirectAttributes redirectAttributes) {
		appBannerService.delete(appBanner);
		addMessage(redirectAttributes, "删除广告位成功");
		return "redirect:"+Global.getAdminPath()+"/banner/appBanner/?repage";
	}
	
	@RequiresPermissions("banner:appBanner:edit")
	@RequestMapping(value = "startBanner")
	public String startBanner(AppBanner appBanner, RedirectAttributes redirectAttributes) {
		appBanner.setBannerStatus("0");
		appBannerService.editStatus(appBanner);
		addMessage(redirectAttributes, "启用广告位成功");
		return "redirect:"+Global.getAdminPath()+"/banner/appBanner/?repage";
	}
	
	@RequiresPermissions("banner:appBanner:edit")
	@RequestMapping(value = "endBanner")
	public String endBanner(AppBanner appBanner, RedirectAttributes redirectAttributes) {
		appBanner.setBannerStatus("1");
		appBannerService.editStatus(appBanner);
		addMessage(redirectAttributes, "禁用广告位成功");
		return "redirect:"+Global.getAdminPath()+"/banner/appBanner/?repage";
	}

}