package com.cku.config;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import org.springframework.core.env.Environment;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableWebMvc
@ComponentScan({ "com.cku.partner.open.club.web", "com.cku.restful.**.web", "com.subscription.restful.web",
		"com.cku.restful.v1.open" })
public class SwaggerConfig extends WebMvcConfigurationSupport {

	/**
	 * 对所有api扫描配置:controller路径
	 */
	// public static final String BASE_PACKAGE = "com.cku.restful.**.web";

	@Bean
	public Docket apiDocket() {
		List<Parameter> operationParameters = new ArrayList<>();
		operationParameters.add(new ParameterBuilder().name("token").description("密文令牌")
				.modelRef(new ModelRef("string")).parameterType("query").required(false).build());
		operationParameters.add(new ParameterBuilder().name("club").description("当前所选俱乐部")
				.modelRef(new ModelRef("string")).parameterType("header").required(false).build());

		return new Docket(DocumentationType.SWAGGER_2).groupName("oa-web").select()
				.apis(RequestHandlerSelectors.any()).paths(PathSelectors.any()).build().apiInfo(getApiInfo())
				.globalOperationParameters(operationParameters);
		// .ignoredParameterTypes(MultiUserProfile.class);
	}

	private ApiInfo getApiInfo() {
		return new ApiInfoBuilder()
				// 页面标题
				.title("CKUOA接口文档")
				// 创建人
				// .contact(new Contact("name", "url", "email"))
				// 版本号
				.version("1.0")
				// 描述
				.description("API 接口文档").build();
	}

}
