//我的优惠劵
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.member = ko.observable(userInfo.getMember());
        me.dataList = ko.observableArray([]);
        //优惠劵状态
        me.state = ko.observable("");
        //优惠劵名称
        me.couponName = ko.observable("");
        //页码列表
        me.pageArray = ko.observableArray();
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findMyCouponList(false);
        }
        //下一页
        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findMyCouponList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findMyCouponList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findMyCouponList(false);
            }
            return false;
        }
        //选择级别
        me.changeState = function(data,event){
            var options=$("#state option:selected");
            me.state(options.val());
        }
        /**
         * 申领资格证书查询方法
         */
        me.findMyCouponList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["memberCode"] = me.member().memberCode;
            sendData["couponName"] = me.couponName;
            sendData["state"] = me.state;
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'coupon/list',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length>0) {
                            var list = data.list;
                            for(var i=0;i<list.length;i++){
                            	if(list[i].validDate.length<=0){
                            		list[i].validDate="永久";
                            	}else{
                            		list[i].validDate=list[i].effectiveDate + "至" + list[i].validDate;
                            	}
                            }
                            me.dataList(list);
                        }else{
                            me.dataList([]);
                            layer.msg("优惠劵列表为空！")
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }
        $(function(){
            me.findMyCouponList(false);
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});
