//学校美容师领取资格证书
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.dataList = ko.observableArray([]);
        //参赛级别
        me.show_level = ko.observable("");
        //活动名称
        me.show_name = ko.observable("");
        //活动地点
        me.show_address = ko.observable("");
        //级别的显隐 默认隐
        me.isShowLevel = ko.observable(false);
        //选择的级别
        me.levelText = ko.observable("全部");
        //报名序号
        me.register_code = ko.observable("");
        //计时器
        me.timeRun = null;
        //在线申领显隐 默认隐
        me.isShowApply = ko.observable(false);
        //页码列表
        me.pageArray = ko.observableArray();
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findCertificateList(false);
        }
        //下一页
        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findCertificateList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findCertificateList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findCertificateList(false);
            }
            return false;
        }
        //级别的显隐事件
        me.showLevel = function(){
            me.isShowLevel(!me.isShowLevel());
        }
        //选择级别
        me.chooseLevel = function(type){
            $("#allLevel li").removeAttr("class");
            $("#"+type).parent("li").attr("class","active");
            var text = $("#"+type).text();
            me.levelText(text);
            if(type=="levelA"){
                me.show_level("A");
            }else if(type=="levelB"){
                me.show_level("B");
            }else if(type=="levelC"){
                me.show_level("C");
            }else if(type=="levelT"){
                me.show_level("教师级")
            }else if(type=="levelAll"){
                me.show_level("");
            }
            me.isShowLevel(!me.isShowLevel());
        }
        /**
         * 申领资格证书查询方法
         */
        me.findCertificateList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["show_level"] = me.show_level();
            sendData["show_name"] = me.show_name();
            sendData["register_code"] = me.register_code();
            sendData["show_address"] = me.show_address();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'groomer/certificateList',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length>0) {
                            var list = data.list;
                            $.each(list, function (index, item) {
                                var durTime = new Date(new Date(util.formatDateLong(item.gradeTime)).getTime() + 180 * 24 * 60 * 60 * 1000).getTime() - new Date().getTime();
                                var showTime = util.endTime(durTime);
                                item["showDurTime"] = ko.observable(showTime);
                            });
                            me.dataList(list);
                        }else{
                            layer.msg(data.msg);
                        }
                        me.timeRun = setInterval(me.setTime,10000);
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }
                }
            });
        }
        //列表倒计时
        me.setTime = function() {
            var list = me.dataList();
            $.each(list, function (index, item) {
                var durTime = new Date(new Date(util.formatDateLong(item.gradeTime)).getTime() + 180 * 24 * 60 * 60 * 1000).getTime() - new Date().getTime();
                //item["durTime"] = durTime;
                var showTime = util.endTime(durTime);
                item.showDurTime(showTime);
            });
            me.dataList(list);
        }
        //在线申领
        me.showApply = function(data,event){
            if(data.grade!='未通过' && data.grade!='缺考'){
                var id = data.id;
                util.sendAjax({
                    url:'groomer/receiveCertificate/'+id,
                    data:{},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(data){
                        if(data.rc==0){
                            layer.msg("添加购物车成功！");
                            context.app.changeCart();
                        }else{
                            layer.msg(data.msg);
                        }
                    }
                });
            }
        }
        $(function(){
            me.findCertificateList(false);
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});
