<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>讲师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnSubmit").click(function(){
				window.location.href="${ctxSchools}/schoolsTeacher/form";
			});
			$("#del").click(function(){
				window.location.href="${ctxSchools}/schoolsTeacher/form";
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
			return false;
		}
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="#">当前位置:讲师管理</a></li>
</ul>
<form:form id="searchForm" modelAttribute="teacherLecturer" action="${ctxSchools}/schoolsTeacher/list" method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
	<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	<ul class="ul-form">
		<li>
			<label>讲师：</label>
			<%--<form:select path="level" class="input-small">--%>
				<%--<form:option label="全部" value=""></form:option>--%>
				<%--<form:option label="A" value="A"></form:option>--%>
				<%--<form:option label="B" value="B"></form:option>--%>
				<%--<form:option label="C" value="C"></form:option>--%>
			<%--</form:select>--%>
			<form:input cssStyle="width: 200px;" path="teacherName" htmlEscape="false" maxlength="100" class="input-medium " placeholder="请输入讲师编号、姓名、手机号"/>
		</li>
		<li><label>添加日期：</label>
			<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate" placeholder="开始时间"
				   value="<fmt:formatDate value="${teacherLecturer.beginCreateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
			<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate" placeholder="结束时间"
				   value="<fmt:formatDate value="${teacherLecturer.endCreateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</li>
		<li class="btns"><input  class="btn btn-primary" type="submit" value="筛选"/>
		</li>
		<li class="clearfix"></li>
	</ul>
</form:form>
<div style="margin-top: 20px;margin-bottom: 20px;">
	<label><strong>讲师列表</strong></label>
	<span  style="float:right;"><input id="btnSubmit" class="btn btn-primary" type="submit" value="添加讲师"/></span>
</div>
<sys:message content="${message}"/>

	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>讲师编号</th>
				<th>讲师姓名</th>
				<th>手机号</th>
				<th>授课等级</th>
				<th>添加时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="teacherLecturer">
			<tr>
				<td>
						${teacherLecturer.teacherIndex}
				</td>
				<td>
						${teacherLecturer.teacherName}
				</td>
				<td>
						${teacherLecturer.tel}
				</td>
				<td>
						${teacherLecturer.level}
				</td>
				<td>
					<fmt:formatDate value="${teacherLecturer.createDate}" pattern="yyyy-MM-dd HH:mm"/>
				</td>
				<td>
						<a href="${ctxSchools}/schoolsTeacher/form?id=${teacherLecturer.id}">编辑</a>

						<a href="${ctxSchools}/schoolsTeacher/del?id=${teacherLecturer.id}" onclick="return confirmx('确认要删除该讲师吗？', this.href)">删除</a>

				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>