<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师活动报名申请</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
	$(document).ready(function() {
		$("#inputForm").validate({
			submitHandler: function(form){
				var memberCode=$("#memberCode").val();
				var showCode=$("#showCode").val();
				var showCategory='${groomerShow.showCategory}';

				var showDogBreedValue = $("input[name='showDogBreed']:checked").val();
				if(showDogBreedValue == '无'){
					var value = $("#showDogBreedId").val();
					if(value == ''){
						alert("请填写比赛犬种");
						return false;
					}
				}
				
				$.ajax({
					type: "POST",
	                dataType:"json",
					data : {'showCode':showCode , 'memberCode':memberCode},
	                url:"${ctxSchools}/schoolsGroomerRegister/registerCheck",
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == true){
	                		$.jBox.alert("您已经报名过了,请勿重复报名!","错误");
	                	}else{
	                		loading('正在提交，请稍等...');
	                		form.submit();
	                	}
	                }
				});
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});
		
		$("#btnSubmit").click(function () {
			layer.load();
			//提交
			$("#inputForm").ajaxSubmit({
				dataType: 'json',
				beforeSubmit: function () {
					if (!$("#inputForm").valid()) {
						layer.closeAll('loading');
						return false;
					}
				},
				success: function (data) {
					if (data.rc == 0) {
						layer.msg("保存成功！");
						window.location = "${ctxSchools}/schoolsGroomerRegister/groomerRegisterList"
					} else {
						layer.msg(data.msg);
						layer.closeAll('loading');
					}
				},
				error: function (err) {
					layer.msg("操作失败!");
					layer.closeAll('loading');
				}
			});
		});
		
		if("${groomerShow.showCategory}" == '3'){
			$("#moxing").hide();
			$("input[type='radio'][name='showLevel']").change(function(){
				if($(this).val()=='国际宠物美容师'){
					$("#moxing").show();
				}else{
					$("#moxing").hide();
					if($('input[type=radio][name=showDogBreed]:checked').val()=='模型'){
						$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked","true");	
					}
				}
			});
		}
		if('${groomerShow.showCategory}' == '6'){
			var testLevel = '${groomerShow.testLevel}'.split(",");
			$.each(testLevel, function (index, value){
				/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
				var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" +value + "</span>";
				$(levelRadioHtml).appendTo("#showLevelDiv");
			});
		}

		if('${groomerShow.showCategory}' == '8'){
			$("#fee").prop("readonly", false);
			var levelMapping = {
				"PRIMARY LEVEL": "宠物级",
				"PROFESSIONAL LEVEL": "专业级",
				"MASTER": "教师级"
			};
			var testLevel = '${groomerShow.testLevel}'.split(",");
			$.each(testLevel, function (index, value){
				var levelName = levelMapping[value] || value;
				/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
				var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" +levelName + "</span>";
				$(levelRadioHtml).appendTo("#showLevelDiv8");
			});
		}
		$('input[name="showLevel"]').on('change', function() {
			updateFeeDisplay();
		});

		// 更新费用显示的函数
		function updateFeeDisplay() {
			var selectedLevel = $('input[name="showLevel"]:checked').val();
			var isFreeFee = ${groomerShow.freeFee};
			if (!isFreeFee) {
				if (selectedLevel === 'PRIMARY LEVEL' || selectedLevel === 'PROFESSIONAL LEVEL') {
					$('#fee').val('300.00');
				} else if (selectedLevel === 'MASTER') {
					$('#fee').val('500.00');
				}
			}
		}
		
		$('input[type=radio][name=showDogBreed]').change(function() {
	          if (this.value == '无') {
	              $("#showDogBreedId").removeAttr("disabled");
	          } else  {
				  $("#showDogBreedId").attr("disabled","disabled");
				  $("#showDogBreedId").val("");
	          }
	    });
		
	});


	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxSchools}/schoolsGroomer/groomerShowList">美容师活动列表</a></li>
		<li class="active"><a href="${ctxSchools}/schoolsGroomer/registerForm?id=${groomerShow.id}">报名录入</a></li>
	</ul>
	<form:form id="inputForm"  modelAttribute="groomerRegister" action="${ctxSchools}/schoolsGroomerRegister/webFrom" method="post" class="form-horizontal">
		<!-- <input id="avatar" name="avatar" type="hidden"> -->
		
		<form:hidden path="showCategory" value="${groomerShow.showCategory}"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode"  htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<input id="selectMember" class="btn btn-primary" value="查询" type="button" onclick="searchUser()"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input  name="gender" class="required" type="radio" value="male" />
                <label>男</label>
                <input  name="gender" class="required" type="radio" value="female" />
                <label>女</label>
			</div>
		</div>
		<c:set var="showLevelHidden" value="${groomerShow.showCategory eq '1' && (groomerShowTypeMap['showType'] eq 'cathedra' || groomerShowTypeMap['showCodeType'] eq 'TT')}"></c:set>
		<div  class="control-group" ${showLevelHidden?'style="display:none"':''}>
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<c:set var="showCategory" value="${groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师"/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师"/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" class="required" type="radio" value="宠物造型师&国际宠物美容师"/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" type="groomer_nurse_level" value="P" rangeItems="${groomerShow.testLevel}" cssClass="required" remarks="注：切换参赛级别请重新选择比赛犬种"></oa:dictRadios>
				    </c:when>
					<c:when test="${groomerShow.showCategory eq '6'}">
						<div id = "showLevelDiv">

						</div>
						<%--<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
						<input  name="showLevel" class="required" type="radio" value="B"/>
						<label>B</label>
						<input name="showLevel" class="required" type="radio" value="A"/>
						<label>A</label>--%>
					</c:when>
					<c:when test="${groomerShow.showCategory eq '8'}">
						<div id = "showLevelDiv8">

						</div>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
			</div>
		</div>
		
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照：</label>
			<div class="controls">
				<!-- <img  id="avatarImg" alt="" src="" style="padding:10px;height:130px;"/> -->
				<sys:schollsSingleImgUpload module="member"  imgId="${groomerRegister.avatar}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" id="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		
		
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<input value="${groomerShow.showName}" type="text" readonly="readonly" id="showName"  class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<input id="showCode" name="showCode" type="text" value="${groomerShow.showCode}" class="input-xlarge required" readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				<input id="fee" name="fee" type="text" value="${groomerShow.fee}" class="input-xlarge required" readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		<c:set var="showLevelHidden" value="${groomerShow.showCategory eq '1' && groomerShowTypeMap['showType'] eq 'cathedra'}"></c:set>
		<div class="control-group" ${showLevelHidden?'style="display:none"':''}>
			<label class="control-label">比赛品种：</label>
			<div class="controls">
				<c:choose>
				    <c:when test="${groomerShow.showCategory eq '4'}">
						<oa:groomerBreeds name="showDogBreed" otherName="showDogBreedExtra" memberElementId="memberCode" levelElementId="showLevel" isSchool="true" cssClass="input-xlarge required"></oa:groomerBreeds>
				    </c:when>
					<c:when test="${groomerShow.showCategory eq '8'}">
						<input name="showDogBreed" type="text" required/><span><font>&nbsp;&nbsp;注:多个品种用空格分隔</font></span>
					</c:when>
				    <c:otherwise>
		                <input name="showDogBreed" class="required" type="radio" value="贵宾" />
		                <label>贵宾</label>
		               	<input name="showDogBreed" class="required" type="radio" value="比熊"/>
		                <label>比熊</label>
		                <input name="showDogBreed" class="required" type="radio" value="雪纳瑞" />
		                <label>雪纳瑞</label>
		                <c:if test="${groomerShow.showCategory eq '2' || groomerShow.showCategory eq '3'}">
							<div id="moxing" style="display:inline-block;">
								<input name="showDogBreed" class="required" type="radio" value="模型"/>
								<label>模型</label>
							</div>
						</c:if>
						<input name="showDogBreed" class="required" type="radio" value="无" />
		                <label>其他犬种: </label>
		                <input id="showDogBreedId" name="showDogBreed" type="text" disabled="disabled"/><span><font>&nbsp;&nbsp;注:多个犬种用空格分隔</font></span>
				    </c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" />&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctxSchools}/schoolsMember/searchGroomer?showCategory=${groomerShow.showCategory}"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			// $("#avatar").val(json.avatar);
			$("#name").val(json.name);
            $("#mobile").val(json.mobile);
            $("#accountBalance").val(json.accountBalance);
            $("#previewImg").attr("src" , "${ctxSchools}/file/image/" + json.avatar);
            $("#avatar").val(json.avatar);
            $("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
            var memberCode=json.memberCode;
            var showCode=$("#showCode").val();
            $.ajax({
                type:"POST",
                url: "${ctxSchools}/schoolsGroomerRegister/getMemberMessage",
                data : {'memberCode':memberCode,'showCode':showCode},
                dataType: 'json',
                async: false,
                success: function(jsons){
                	if (jsons.rc==0) {
						var showCategory='${groomerShow.showCategory}';
                		// $("input[type=radio][name='showLevel'][value="+jsons.showLevel+"]").attr("checked",'checked');
						if(showCategory=='1'){
							$.each(jsons, function(index,item) {
								// $("input[type=radio][name='showLevel'][value="+item+"]").attr("checked",'checked');
							});
						}
						if(showCategory=='2'){
							$.each($('#otherLevelT [type=radio]'),function(){
								$(this).attr("checked","checked");
							});
						}
						if(showCategory=='3'){
							// $.each($('#otherLevelR [type=checkbox]'),function(){
							// 	$(this).attr("checked","checked");
							// 	$("#otherLevelR [type=checkbox][name='showLevel'][value='"+index+"']").attr("checked",'checked');
							// });
							$("#otherLevelR [type=radio][name='showLevel'][value='宠物造型师&国际宠物美容师']").attr("checked",'checked');
						}
						if(showCategory=='4'){
						}
					}else if(jsons.rc==1){
						$.jBox.alert(jsons.msg,"提示");
						$("#memberCode").val('');
						$("#name").val('');
						$("#mobile").val('');
			            $("#accountBalance").val('');
			            $("input[type=radio][name='gender']").removeAttr("checked");
					}
                }
            });
		}

	</script>
</body>
</html>