<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
	<title>门店添加</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function () {
			//悬浮提示插件
			$(document).tooltip();
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function (form) {
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function (error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function deleteImg(type){
			$("#"+type+"Show").attr("src","");
			$("#"+type+"Show").removeAttr("style");
			$("#"+type).val("");
		}
		function showImg(type){
			var src = $("#"+type+"Show").attr("src");
			if(src=="")
				return;
			parent.layer.open({
				type: 1,
				title: false,
				area: ['800px', '600px'],
				closeBtn: 0,
				skin: 'layui-layer-nobg', //没有背景色
				shadeClose: true,
				content: "<img src='"+src+"'>"
			});
			;
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctxPartner}/org/list">门店列表</a></li>
	<li class="active"><a href="${ctxPartner}/org/form">门店添加</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="org" action="${ctxPartner}/org/save" method="post"
		   class="form-horizontal">
	<form:hidden path="id"/>

	<div class="control-group">
		<label class="control-label">门店类型：</label>
		<div class="controls">
			${fns:getDictLabel(org.orgType, 'sys_org_type', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">登录账号：</label>
		<div class="controls">
			${fns:escapeHtml(org.user.loginName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">密码：</label>
		<div class="controls">
			******
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">门店名称：</label>
		<div class="controls">
			${fns:escapeHtml(org.name)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">负责人：</label>
		<div class="controls">
			${fns:escapeHtml(org.contact)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">联系电话：</label>
		<div class="controls">
			${fns:escapeHtml(org.tel)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">座机电话：</label>
		<div class="controls">
			${fns:escapeHtml(org.landlinePhone)}
		</div>
	</div>
	</div>
	<div class="control-group">
		<label class="control-label">门店地址：</label>
		<div class="controls">
			${fns:escapeHtml(org.address)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">C级鉴定师：</label>
		<div class="controls">
				${fns:escapeHtml(org.jianDingshi1)}&nbsp;&nbsp;&nbsp;&nbsp;
				${fns:escapeHtml(org.jianDingshi2)}
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">推荐人：</label>
		<div class="controls">
				${org2.name}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">资质上传：</label>
		<div class="controls">
			营业执照照片：<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${org.yingyePic}">
			&nbsp;&nbsp;兽医资格照片：<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${org.shouYiPic}">
			&nbsp;&nbsp;门店照片：<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${org.mendian1Pic}">
		</div>
	</div>

	</div>
	<div class="form-actions">
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>