<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body >
	<div style="padding:10px;">
	<form:form id="searchForm" modelAttribute="member" action="${ctx}/sys/user/member/search" method="post" class="breadcrumb form-search" >
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员编号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li><label>姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>会员类型</th>
				<th>缴费状态</th>
				<th>冻结状态</th>
				<th>余额</th>
				<th>头像</th>
				<shiro:hasPermission name="sys:user:member:edit"><th>选择</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:if test="${page.count == 0 }">
		<tr> <td colspan="8">没有找到任何会员信息，请输入会员号/会员姓名进行查询</td></tr></c:if>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
				</td>
				<td>
					${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td>
					${fns:escapeHtml(member.freezeFlag=='1'?'已冻结':'未冻结')}
				</td>
				<td>
					${fns:escapeHtml(member.accountBalance) }
				</td>
				<td>
					${fns:escapeHtml(not empty member.avatar?'有':'无') }
				</td>
				<td>
    					<a href="#" onclick="select('${fns:escapeHtml(member.memberCode) }','${fns:escapeHtml(member.name)}','${member.gender}','${member.paymentState}','${member.memberType}','${member.memberCardType}','${member.accountBalance}','${fns:escapeHtml(member.mobile)}','${fns:escapeHtml(member.phone)}','${fns:escapeHtml(member.avatar) }','${fns:escapeHtml(member.province)}','${fns:escapeHtml(member.city)}','${fns:escapeHtml(member.area)}','${fns:escapeHtml(member.street)}','${member.postcode }','${fns:escapeHtml(member.deliveryCertified) }')">选择</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	</div>
	<script type="text/javascript">
		function select(memberCode,name,gender,paymentState,memberType,memberCardType,accountBalance,mobile,phone,avatar,province,city,area,street,postcode,deliveryCertified){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			var member = {
					memberCode:memberCode,
					name:name,
					gender:gender,
					paymentState:paymentState,
					memberType:memberType,
					memberCardType:memberCardType,
					accountBalance:accountBalance,
					mobile:mobile,
					phone:phone,
					avatar:avatar,
					province:province,
					city:city,
					area:area,
					street:street,
					postcode:postcode,
					deliveryCertified:deliveryCertified
			}
			if(parent.document.getElementById("mainFrame").contentWindow.searchUserCallback != undefined){
				parent.document.getElementById("mainFrame").contentWindow.searchUserCallback(member);
			}
			parent.layer.close(index);
		}
	</script>
</body>
</html>