<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>商品退回</title>
    <meta name="decorator" content="default"/>
</head>
<body>
<div class="container"  style="width: 700px;">
    <form class="form-horizontal" id="searchForm">
        <input type="hidden" name="id" value="${shopOrder.id}">
            <c:if test="${shopOrder.orderDetailList!=null || fn:length(shopOrder.orderDetailList)>0}">
                <table id="goods" class="table table-striped table-bordered table-condensed">
                    <thead>
                    <tr>
                        <td>名称</td><td>单价</td><td>数量</td><td>退回数量</td><td>退回原因</td>
                    </tr>
                    </thead>
                    <tbody>
                    <c:forEach items="${shopOrder.orderDetailList}" var="orderDetail" varStatus="status">
                        <tr>
                            <input type="hidden" name="orderDetailList[${status.index}].id" value="${orderDetail.id}">
                            <td>${fns:escapeHtml(orderDetail.goodsName)}</td>
                            <td>${fns:escapeHtml(orderDetail.goodsPrice)}</td>
                            <td id="goodNum${status.index}">${fns:escapeHtml(orderDetail.goodsNum)}</td>
                            <td style="width: 55px;"><input type="number" min="1" id="returnNum${status.index}" step="1" value="1" name="orderDetailList[${status.index}].returnNum" style="width: 50px;" /></td>
                            <td style="width: 230px;"><input type="text" id="returnRemarks${status.index}" name="orderDetailList[${status.index}].returnRemarks" style="width: 220px;" /></td>
                        </tr>
                    </c:forEach>
                    </tbody>
                </table>
            </c:if>
        <div class="form-actions">
            <input id="btnSubmit" class="btn btn-primary" onclick="save()" type="button" value="保 存"/>&nbsp;
            <input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()"/>
        </div>
    </form>
</div>
<script>
    var len = ${fn:length(shopOrder.orderDetailList)};
    len = parseInt(len);
    $(function(){
        parent.isYes = false;
    })
    function closeLayer(){
        parent.layer.closeAll();
    }
    function save(){
        var goodNum = 0;
        var returnNum = 0;
        var returnRemarks = '';
        for(var i=0;i<len;i++){
            goodNum = parseInt($("#goodNum"+i).html());
            returnNum = parseInt($("#returnNum"+i).val());
            returnRemarks = $("#returnRemarks"+i).val();
            if(isNaN(returnNum)){
            	alert("请输入退货数量！");
            	return;
            }
            if(goodNum<returnNum){
                alert("退货数量应小于购买数量！");
                return;
            }
            if(returnNum>0 && util.isVal(returnRemarks)==""){
                alert("退货原因不能为空");
                return;
            }
        }
        var data = util.getFormJson($("#searchForm"));
        $.ajax({
            type: "POST",
            url:"${ctx}/shop/shopOrder/returnGoods",
            dataType:"json",
            data:data,// 你的formid
            async: false,
            error: function(request, textStatus, errorThrown) {
                alert("系统错误，请联系管理员！");
            },
            success: function(data) {
                parent.isYes = true;
                parent.layer.closeAll();
            }
        });
    }
</script>
</body>
</html>