<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/order/businessOrder/">商品订单列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="businessOrder" action="${ctx}/order/businessOrder/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>分类名称：</label>
				<form:input path="cateName" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>业务名称：</label>
				<form:input path="businessName" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>商品名称：</label>
				<form:input path="skuName" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>订单号：</label>
				<form:input path="orderCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>分类名称</th>
				<th>业务名称</th>
				<th>商品名称</th>
				<th>单价</th>
				<th>数量</th>
				<th>总价</th>
				<th>办理人会员号</th>
				<th>订单号</th>
				<th>收费项名称</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="businessOrder">
			<tr>
				<td>
					${businessOrder.cateName}
				</td>
				<td>
					${businessOrder.businessName}
				</td>
				<td>
					${businessOrder.skuName}
				</td>
				<td>
					${businessOrder.unitPrice}
				</td>
				<td>
					${businessOrder.num}
				</td>
				<td>
					${businessOrder.totalPrice}
				</td>
				<td>
					${businessOrder.memberCode}
				</td>
				<td>
					${businessOrder.orderCode}
				</td>
				<td>
					${businessOrder.chargingItemNames}
				</td>
				<td>
					<a href="${ctx}/order/businessOrder/viewForm?id=${businessOrder.id}">查看</a>
					<shiro:hasPermission name="order:businessOrder:edit">
						<a href="${ctx}/order/businessOrder/editForm?id=${businessOrder.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="order:businessOrder:del">
						<a href="${ctx}/order/businessOrder/delete?id=${businessOrder.id}"
						   onclick="return confirmx('确认要删除该商品订单吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>