<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍名称变更申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					$.post('${ctx}/kennel/kennelRename/audit',
							$('#inputForm').serialize(),
							function(data){
								if(data.rc==0){
									alert("审核成功！");
									top.isYes=true;
									parent.isYes = true;
									parent.layer.closeAll();
								}else{
									alert("审核失败,错误信息："+data.msg);
								}
					});
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<form:form id="inputForm" modelAttribute="kennelRename" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input path="originalNameCn" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input path="originalNameEn" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬舍中文名：</label>
			<div class="controls">
				<form:input path="newNameCn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬舍英文名：</label>
			<div class="controls">
				<form:input path="newNameEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
			<div class="control-group">
			<label class="control-label">新FCI犬舍英文名：</label>
			<div class="controls">
				<form:input path="fciKennel" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
			<div class="control-group">
			<label class="control-label">备用FCI犬舍英文名：</label>
			<div class="controls">
				<form:input path="fciKennelBackup" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">未通过的原因：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" rows="3" cols="20" maxlength="255" class="input-xlarge "/>
			</div>
		</div>		
		<div class="control-group" style="text-align:center;">
			<shiro:hasPermission name="kennel:kennelRename:audit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>