<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>ip黑名单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/ipaddress/ipBlackList/">ip黑名单列表</a></li>
		<%-- <shiro:hasPermission name="ipaddress:ipBlackList:edit"><li><a href="${ctx}/ipaddress/ipBlackList/form">ip_black_list映射表添加</a></li></shiro:hasPermission> --%>
	</ul>
	<form:form id="searchForm" modelAttribute="ipBlackList" action="${ctx}/ipaddress/ipBlackList/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>ip：</label>
				<form:input path="ip" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<td>ip</td>
				<shiro:hasPermission name="ipaddress:ipBlackList:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ipBlackList">
			<tr>
				<td>${ipBlackList.ip}</td>
				<shiro:hasPermission name="ipaddress:ipBlackList:edit"><td>
					<c:if test="${ipBlackList.status == '0'}">
						<a href="${ctx}/ipaddress/ipBlackList/edit?ip=${ipBlackList.ip}&status=1" onclick="return confirmx('确认要开放该ip吗？', this.href)">开放</a>
					</c:if>
					<c:if test="${ipBlackList.status == '1'}">
						<a href="${ctx}/ipaddress/ipBlackList/edit?ip=${ipBlackList.ip}&status=0" onclick="return confirmx('确认要禁止该ip吗？', this.href)">禁止</a>
					</c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>