<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>方案管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }


        function create(id){
        	 $.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/handler/refereeRankingSchem/updateStatus?id="+id,
	                async: false,
	                
	                success: function(data) {
	                	if(data.data == "OK"){
		                	alert("数据生成中，请稍后查看");
		                	createData(id);
		                }
	                }
				});

        }


        function createData(id){
           	$.ajax({
				type: "GET",
                url:"${ctx}/handler/refereeRankingSchem/create?id="+id
			});

            setTimeout(function(){
            	window.location.reload(true);
             },500);
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/refereeRankingSchem/">方案列表</a></li>
		<shiro:hasPermission name="handler:refereeRankingSchem:view"><li><a href="${ctx}/handler/refereeRankingSchem/form">方案添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="refereeRankingSchem" action="${ctx}/handler/refereeRankingSchem/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>年份：</label>
				<form:select path="year" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${yearList}" var="year">
						<form:option value="${year}" label="${year}年"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('referee_schem_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			
			<li><label>季度：</label>
				<form:select path="quarter" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('quarter')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>月份：</label>
				<form:select path="month" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${monthList}" var="month">
						<form:option value="${month}" label="${month}月"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>半年度：</label>
				<form:select path="half" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="上半年"/>
					<form:option value="2" label="下半年"/>
				</form:select>
			</li>
			<li><label>状态：</label>
				<form:select path="status" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('schem_status')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>描述</th>
				<th>类型</th>
				<th>年份</th>
				<th>季度</th>
				<th>月份</th>
				<th>半年度</th>
				<th>状态</th>
				<shiro:hasPermission name="handler:refereeRankingSchem:view"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="refereeRankingSchem">
			<tr>
				<td>
					${refereeRankingSchem.serialNum}
				</td>
				<td>
					${refereeRankingSchem.remarks}
				</td>
				<td>
					${fns:getDictLabel(refereeRankingSchem.type, 'referee_schem_type', '')}
				</td>
				<td>
					${refereeRankingSchem.year}
				</td>
				
				<td>
					${fns:getDictLabel(refereeRankingSchem.quarter, 'quarter', '')}
				</td>
				<td>
					${refereeRankingSchem.month}
				</td>
				
				<td>
					<c:if test="${refereeRankingSchem.half eq '1'}">上半年</c:if>
					<c:if test="${refereeRankingSchem.half eq '2'}">下半年</c:if>
				</td>
				<td>
					${fns:getDictLabel(refereeRankingSchem.status, 'schem_status', '')}
				</td>
				<shiro:hasPermission name="handler:refereeRankingSchem:view">
				<td>
					<c:if test="${refereeRankingSchem.status eq '0'}">
						<a href="javascript:void(0);"  onclick="create('${refereeRankingSchem.id}');return false;" >生成数据</a>
					</c:if>
					<c:if test="${refereeRankingSchem.status eq '1' }">
						生成中...
					</c:if>
					<c:if test="${refereeRankingSchem.status eq '2' }">
						已生成
					</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>