<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>结业证书管理</title>
	<meta name="decorator" content="default"/>

</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerDiploma/handlerView?id=${handlerDiploma.id}">结业证书查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerDiploma"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerDiploma.startDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerDiploma.endDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训教师：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.teacher)}
			</div>
		</div>
			<div class="control-group">
			<label class="control-label">中文学校名：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.schoolNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校英文名：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.schoolNameEn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.certificateLevel)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				${fns:escapeHtml(handlerDiploma.certificateCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
					<fmt:formatDate value="${handlerDiploma.issueDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>