<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>轮播图</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnSubmit").click(function(){
				window.location.href="${ctx}/groomer/rotationChart/fromAdd";
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
			return false;
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/rotationChart/list">人才板块</a></li>
	</ul>
	<div style="margin-top: 20px;margin-bottom: 20px;">
		<label><strong>轮播图列表</strong></label>
		<span  style="float:right;"><input id="btnSubmit" class="btn btn-primary" type="submit" value="添加轮播图"/></span>
	</div>

	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>名称</th>
				<th>缩略图</th>
				<th>说明</th>
				<th>上传人</th>
				<th>添加时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="rotationChart">
			<tr>
				<td>
						${rotationChart.rotationIndex}
				</td>
				<td>
						${rotationChart.rotationName}
				</td>
				<td>

					<img src="${ctx}/sys/file/image/${rotationChart.rotationPicture}" style="padding:10px;height:130px;">
				</td>
				<td>
						${rotationChart.rotationExplain}
				</td>
				<td>
						${rotationChart.createBy.name}
				</td>
				<td>
					<fmt:formatDate value="${rotationChart.createDate}" pattern="yyyy-MM-dd HH:mm"/>
				</td>
				<td>
					<shiro:hasPermission name="groomer:rotationChart:edit">
						<a href="${ctx}/groomer/rotationChart/form?id=${rotationChart.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="groomer:rotationChart:del">
						<a href="${ctx}/groomer/rotationChart/del?id=${rotationChart.id}" onclick="return confirmx('确认要删除该轮播图吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>