<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>CKU培训部-活动录入</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			var bo;
			$("#showCode").blur(function(){
				var showCode = encodeURI($("#showCode").val());
				var id=$("#id").val();
				$.ajax({
					type: "POST",
					dataType:"json",
					url:"${ctx}/groomer/groomerShow/codeCheck?showCode="+showCode+"&id="+id,
					async: false,
					error: function(request, textStatus, errorThrown) {
						alert("请求失败！");
					},
					success: function(data) {
						if(data.rc == false){
							bo = data.rc;
							$("#showCodeError").html('赛事编号已经存在！');
							alert('赛事编号已经存在！');
							$("#showCodeError").show();
						}else{
							bo = data.rc;
						}

					}
				})

			});
			$("#showCode").focus(function(){
				$("#showCodeError").hide();
			})

			$("#btnSubmit").click(function () {
				$("input[name='registerType']:checked").each(function () {
					if ('school' == $(this).val()) {
						var schools = $("#schools").val();
						if ('' == schools) {
							alert("请选择考点！");
							return;
						}

						// 活动分类（美容师资格认证）选择考点后仅能选考试类型
						var showCategory = $("#showCategory").val();
						if ("1" == showCategory) {
							var showType = $("#showType").val();
							if ('exam' != showType) {
								alert("考点报名仅支持考试类型活动！");
								return;
							}
						}
					}
				});
				//赛事编号
				if (bo == false) {
					$("#showCodeError").attr("value", '赛事编号已经存在！');
					alert('赛事编号已经存在！');
					$("#showCodeError").show();
					return;
				}
				//活动图片
				if ($("#showPhoto").val() == "") {
					alert("活动图片不能为空！");
					return;
				}
				//活动类型
				var showCategory = $("#showCategory").val();
				var showType = $("#showType").val();
				if (showCategory == '2' || showCategory == '3' || showCategory == '4') {
					if (showType == 'cathedra' || showType == 'team') {
						alert("国际宠物美容师认证、CKU国际宠物洗护师认证、宠物造型师&国际宠物美容师认证，活动类型无法报名讲座或团体挑战赛！");
						return;
					}
				}
				layer.load();
				//提交
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid()) {
							layer.closeAll('loading');
							return false;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg("保存成功！");
							window.location = "${ctx}/groomer/groomerShow/"
						} else {
							layer.msg(data.msg);
							layer.closeAll('loading');
						}
					},
					error: function (err) {
						layer.closeAll('loading');
						layer.msg("操作失败!");
					}
				});
			});
			$("#schoolsDiv").hide();
			// 回显报名方式
			var registerType = '${fns:escapeHtml(groomerShow.registerType)}';
			var registerTypeArray = registerType.split(",");
			$.each(registerTypeArray, function(i,val) {
				$("input[type=checkbox][name='registerType'][value="+val+"]").attr("checked",'checked');
				if(val == 'school'){
					$("#schoolsDiv").show();
					// 回显考试地点
					var schools = '${fns:escapeHtml(groomerShow.schools)}';
					var schoolsArray = schools.split(",");
					$.each(schoolsArray, function(i,val) {
						$("#schools").find("option[value='"+val+"']").attr("selected",true);
					});
					$("#schools").trigger("change");
				}
			});



			//回显裁判信息
			var referee = '${fns:escapeHtml(groomerShow.referee)}';
			var refereeArray = referee.split(",");
			$.each(refereeArray, function(i,val) {
				$("#referee").find("option[value='"+val+"']").attr("selected",true);
			});
			$("#referee").trigger("change");

			var $select = $('#showCategory');
			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
			//回显参赛级别
			let showCategory = $('#showCategory option:selected').val();
			changeLevel(showCategory);
			var testLevel = '${fns:escapeHtml(groomerShow.testLevel)}'.split(",");
			if (testLevel.length > 0) {
				//国际宠物美容师认证
				if (showCategory == '2') {
					$.each(testLevel, function (index, item) {
						$("#otherLevelT input[type=checkbox][name='testLevel'][value='" + item + "']").attr("checked", 'checked');
					});
				} else if (showCategory == '3') {
					//宠物造型师&国际宠物美容师认证
					$.each(testLevel, function (index, item) {
						$("#otherLevelR input[type=checkbox][name='testLevel'][value='" + htmlDecode(item) + "']").attr("checked", 'checked');
					});
				} else if (showCategory == '8') {
					//伴侣猫洗护师资格认证
					$.each(testLevel, function (index, item) {
						$("#otherLevelCatNurse input[type=checkbox][name='testLevel'][value='" + htmlDecode(item) + "']").attr("checked", 'checked');
					});
				} else {
					$.each(testLevel, function (index, item) {
						$("input[type=checkbox][name='testLevel'][value=" + item + "]").attr("checked", 'checked');
					});
				}
			}

			// 考试地点联动
			$("input[name='registerType']").change(function () {
				var array = [];
				$("input[name='registerType']:checked").each(function () {
					array.push($(this).val());
				});

				if ($.inArray('school', array) != -1) {
					$("#schoolsDiv").show();
				} else {
					$("#schoolsDiv").hide();
				}
			});

			$('#showCategory').on("change", function(e) {
				changeLevel(e.val);
			})

			$('#freeFee').on('change', function() {
				if ($(this).is(':checked')) {
					$("#fee").val("0.00");
					$("#fee").prop("readonly", true);
				} else {
					$("#fee").prop("readonly", false);
				}
			});
		});

		function changeLevel(showCategory) {
			// 清除级别
			$("input[name=testLevel]").each(function () {
				$(this).attr("checked", false);
			});
			//选中的值
			//美容师资格认证
			if (showCategory == '1') {
				$("#selectCategory").hide();
				$("#otherLevelO").show();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelPdg").hide()
				$("#fee").prop("readonly", false);
				$("#freeFee").prop("disabled", false);
				$(".otherLevelFciAndPdg").each(function(){
					$(this).prop("disabled", false);
				});
				$("#otherLevelCatNurse").hide();
			}
			//国际宠物美容师认证
			if (showCategory == '2') {
				$("#selectCategory").hide();
				$("#otherLevelO").hide();
				$("#otherLevelT").show();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelPdg").hide()
				$("#otherLevelFci").hide();
				$("#freeFee").prop("disabled", false);
				$("#fee").prop("readonly", false);
				$("#otherLevelCatNurse").hide();

			}
			//宠物造型师&国际宠物美容师认证
			if (showCategory == '3') {
				$("#selectCategory").hide();
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").show();
				$("#otherLevelNurse").hide();
				$("#otherLevelPdg").hide()
				$("#otherLevelFci").hide();
				$("#freeFee").prop("disabled", false);
				$("#fee").prop("readonly", false);
				$("#otherLevelCatNurse").hide();
			}
			if (showCategory == '4') {
				$("#selectCategory").hide();
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").show();
				$("#otherLevelPdg").hide();
				$("#otherLevelFci").hide();
				$("#freeFee").prop("disabled", false);
				$("#fee").prop("readonly", false);
				$("#otherLevelCatNurse").hide();
			}
			if (showCategory == '6') {
				$("#selectCategory").hide();
				$("#otherLevelO").show();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$("#otherLevelPdg").show();
				$("#otherLevelFci").hide();
				$("#freeFee").prop("disabled", false);
				$("#fee").prop("readonly", false);
				$(".otherLevelFciAndPdg").each(function(){
					$(this).prop("disabled", true);
				});
				$("#otherLevelCatNurse").hide();
			}
			if (showCategory == '7') {
				$("#selectCategory").hide();
				$("#otherLevelO").show();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$(".otherLevelFciAndPdg").each(function(){
					$(this).prop("disabled", true);
				});
				$("#freeFee").prop("disabled", true);
				$("#fee").prop("readonly", true).prop("value","500");
				$("#otherLevelCatNurse").hide();
			}
			//伴侣猫洗护资格认证
			if (showCategory == '8') {
				$("#selectCategory").hide();
				$("#otherLevelO").hide();
				$("#otherLevelT").hide();
				$("#otherLevelR").hide();
				$("#otherLevelNurse").hide();
				$(".otherLevelFciAndPdg").each(function(){
					$(this).prop("disabled", true);
				});
				$("#freeFee").prop("disabled", false);
				$("#fee").prop("readonly", false);
				$("#otherLevelCatNurse").show();
			}


		}

		function htmlDecode(str){
			var s = "";
			if(str.length == 0) return "";
			s = str.replace(/&amp;/g,"&");
			s = s.replace(/&lt;/g,"<");
			s = s.replace(/&gt;/g,">");
			s = s.replace(/&nbsp;/g," ");
			s = s.replace(/'/g,"\'");
			s = s.replace(/"/g,"\"");
			return s;
		}
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctx}/groomer/groomerShow/">活动管理</a></li>
	<li class="active"><a href="${ctx}/groomer/groomerShow/form?id=${groomerShow.id}">美容活动<shiro:hasPermission name="groomer:groomerShow:${not empty groomerShow.id?'edit':'add'}">${not empty groomerShow.id?'修改':'添加'}</shiro:hasPermission></a></li>
</ul>
<form:form id="inputForm" modelAttribute="groomerShow" action="${ctx}/groomer/groomerShow/save" method="post" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<div class="control-group">
		<label class="control-label">赛事编号：</label>
		<div class="controls">
			<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			<span id="showCodeError" style="color:red;display:none" class="error"></span>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">报名方式：</label>
		<div class="controls">
			<input name="registerType" maxlength="50" class="input-xlarge required" type="checkbox" value="app" readonly="readonly"/>
			<label>公开报名</label>
			<input  name="registerType" maxlength="50" class="input-xlarge required" type="checkbox" value="school" readonly="readonly"/>
			<label>考点报名（仅支持考试类型活动） </label>
		</div>
	</div>

	<div id="schoolsDiv" class="control-group">
		<label class="control-label">考试地点：</label>
		<div class="controls">
			<form:select id="schools" path="schools" class="input-xlarge" multiple="true" style="width: 284px;">
				<form:options items="${schools}" itemLabel="schoolNameCn" itemValue="id" htmlEscape="false"/>
			</form:select>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">开始日期：</label>
		<div class="controls">
			<input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate required"
				   value="<fmt:formatDate value="${groomerShow.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">结束日期：</label>
		<div class="controls">
			<input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate required"
				   value="<fmt:formatDate value="${groomerShow.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">活动名称：</label>
		<div class="controls">
			<form:input path="showName" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
		</div>
	</div>
	<div class="control-group" style="width:80%">
		<label class="control-label">活动图片：</label>
		<div class="controls">
			<sys:singleImgUpload module="member"  imgId="${groomerShow.showPhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess" />
			<form:input path="showPhoto" id="showPhoto" htmlEscape="false" maxlength="255" class="input-xlarge" type="hidden" />
			<!-- 文件上传成功的回调方法 -->
			<script type="text/javascript">
				function uploadSuccess(file,response){
					$("#showPhoto").val(response.id);
				}
			</script>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">活动地点：</label>
		<div class="controls">
			<form:input path="showAddress" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">活动分类：</label>
		<div class="controls">
			<form:select path="showCategory" class="input-xlarge required" style="width: 284px;">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">活动类型：</label>
		<div class="controls">
			<form:select path="showType" class="input-xlarge required" style="width: 284px;">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
			<font id="showTypeText" color="#FF0000" style="margin-left: 10px;">目前Fci活动仅支持比赛 </font>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">截止时间：</label>
		<div class="controls">
			<input name="registerEndTime" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate required"
				   value="<fmt:formatDate value="${groomerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">裁判：</label>
		<div class="controls">
			<form:select path="referee" class="input-xlarge" multiple="true" style="width: 284px;">
				<form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="id" htmlEscape="false"/>
			</form:select>
			<font color="#FF0000" style="margin-left: 10px;">注：可以多选裁判！ </font>
		</div>
	</div>
	<%-- <div class="control-group">
        <label class="control-label">报名优惠：</label>
        <div class="controls">
            <form:input path="discount" htmlEscape="false" maxlength="255" class="input-xlarge "/>
        </div>
    </div> --%>
	<div class="control-group">
		<label class="control-label">报名费：</label>
		<div class="controls">
			<form:input path="fee" htmlEscape="false" class="input-xlarge required" readonly="${groomerShow.freeFee eq true ? 'true':'false'}" />
			<form:checkbox id="freeFee" path="freeFee" label="免费报名" />
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">参赛级别：</label>
		<div class="controls" id="selectCategory"><input class="input-xlarge" type="text" placeholder="请先选择活动分类" disabled="true"/></div>
		<div id="otherLevelO" class="controls" style="display: none;">
			<input name="testLevel" maxlength="50" class="input-xlarge required otherLevelFciAndPdg" type="checkbox" value="none" readonly="readonly"/>
			<label>无</label>
			<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="C" readonly="readonly"/>
			<label>C</label>
			<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="B" readonly="readonly"/>
			<label>B</label>
			<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="A" readonly="readonly"/>
			<label>A</label>
			<input name="testLevel" maxlength="50" class="input-xlarge required otherLevelFciAndPdg" type="checkbox" value="MASTER" readonly="readonly" />
			<label>教师</label>
		</div>
		<div id="otherLevelT" class="controls" style="display: none;">
			<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="国际宠物美容师" readonly="readonly"/>
			<label>国际宠物美容师</label>
		</div>
		<div id="otherLevelR" class="controls" style="display: none;">
			<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="国际宠物美容师" readonly="readonly"/>
			<label>国际宠物美容师</label>
			<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="宠物造型师&国际宠物美容师" readonly="readonly"/>
			<label>宠物造型师&国际宠物美容师</label>
		</div>
		<div id="otherLevelNurse" class="controls" style="display: none;">
			<form:checkboxes path="testLevel" items="${fns:getDictList('groomer_nurse_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
		</div>
		<div id="otherLevelCatNurse" class="controls" style="display: none;">
			<input name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="PRIMARY LEVEL" readonly="readonly"/>
			<label>宠物级</label>
			<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="PROFESSIONAL LEVEL" readonly="readonly"/>
			<label>专业级</label>
			<input  name="testLevel" maxlength="50" class="input-xlarge required" type="checkbox" value="MASTER" readonly="readonly"/>
			<label>教师级</label>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">备注信息：</label>
		<div class="controls">
			<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xlarge" style="resize: none;"/>
		</div>
	</div>
	<div class="form-actions">
		<shiro:hasPermission name="groomer:groomerShow:${not empty groomerShow.id?'edit':'add'}">
			<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
		</shiro:hasPermission>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>