<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
	<title>美容资格证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
        $(document).ready(function () {
            //初始化
            $('#memberName').attr('readOnly', 'true');
            $('#memberCode').attr('readOnly', 'true');
            $('#ckuCertificateLevel').attr('disabled', 'true');
            $('#runningNumber').attr('disabled', 'true');
            $('#paymentState').attr('disabled', 'true');
            $('#paymentTime').attr('disabled', 'true');
            //是否只读
            let isView = '${isView}';
            if (isView == 1) {
                $('#btnSubmit').hide();
                $('#inputForm input').attr('disabled', 'true');
                $('#inputForm select').attr('disabled', 'true');
                $('#inputForm textarea').attr('disabled', 'true');
                $('#inputForm input').unbind();
                $('#btnCancel').removeAttr('disabled');
                $('#searchMember').hide();
                $('#memberName').hide();
            } else {
                //是否新增
                let id = '${groomerQualificationCertificateChange.id}';
                if (!id) {
                    //新增
                    $('#ckuCertificateLevelDiv').hide();
                    $('#runningNumberDiv').hide();
                    $('#paymentStateDiv').hide();
                    $('#paymentTimeDiv').hide();
                    $('#reviewStateDiv').hide();
                    $('#reviewTimeDiv').hide();
                    $('#reviewRemarksDiv').hide();
                    $('#reviewState').attr('disabled', 'true');
                    $('#reviewTime').attr('disabled', 'true');
                    $('#reviewRemarks').attr('disabled', 'true');
                } else {
                    //修改
                    $('#memberName').hide();
                    $('#searchMember').hide();
                    let paymentState = $('#paymentState').val();
                    if (paymentState == '2') {
                        $('#certificateSource').attr('readOnly', 'true');
                        $('#certificateLevel').attr('readOnly', 'true');
                        //已缴费
                        let reviewState = $('#reviewState').val();
                        if (reviewState == '1') {
                            //审核通过
                            $('#reviewState').attr('disabled', 'true');
                            $('#reviewTime').attr('disabled', 'true');
                            $('#reviewRemarks').attr('disabled', 'true');
                            $('#breedCate').attr('readOnly', 'true');
                            $('#reviewer').attr('readOnly', 'true');
                            $('#issueDate').removeAttr("onclick");
                        } else {
                            //审核不为通过
                        }
                    } else {
                        //未缴费
                        $('#reviewStateDiv').hide();
                        $('#reviewTimeDiv').hide();
                        $('#reviewRemarksDiv').hide();
                        $('#reviewState').attr('disabled', 'true');
                        $('#reviewTime').attr('disabled', 'true');
                        $('#reviewRemarks').attr('disabled', 'true');
                    }
                }
            }


            // 保存事件
            $("#btnSubmit").click(function () {
                let memberCode = $('#memberCode').val();
                if (!memberCode) {
                    alert("请先查询会员信息");
                    return;
                }
                $("#inputForm").ajaxSubmit({
                    dataType: 'json',
                    beforeSubmit: function () {
                        if (!$("#inputForm").valid()) {
                            return false;
                        }
                    },
                    success: function (data) {
                        if (data.rc == 0) {
                            layer.msg("保存成功！");
                            window.location = "${ctx}/groomer/groomerQualificationCertificateChange/"
                        } else {
                            layer.msg(data.msg);
                        }
                    },
                    error: function (err) {
                        layer.msg("操作失败!");
                    }
                });
            });

        });

        //打开查询用户的弹窗
        function searchUser() {
            top.layer.open({
                type: 2,
                title: ['会员查询', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '500px'],
                content: "${ctx}/sys/user/member/search"
            });
        }

        //查询用户完成的回调方法
        searchUserCallback = function (json) {
            $("#memberCode").val(json.memberCode);
            $("#memberName").val(json.name);
        }
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctx}/groomer/groomerQualificationCertificateChange/">资格证书换发列表</a></li>
	<li class="active">
		<c:choose>
			<c:when test="${not empty groomerQualificationCertificateChange.id and isView == 1}">
				<a href="${ctx}/groomer/groomerQualificationCertificateChange/viewForm?id=${groomerQualificationCertificateChange.id}">资格证书换发查看</a>
			</c:when>
			<c:when test="${not empty groomerQualificationCertificateChange.id and isView == 0}">
				<a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm?id=${groomerQualificationCertificateChange.id}">资格证书换发修改</a>
			</c:when>
			<c:otherwise>
				<a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm?id=${groomerQualificationCertificateChange.id}">资格证书换发添加</a>
			</c:otherwise>
		</c:choose>
	</li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="groomerQualificationCertificateChange"
           action="${ctx}/groomer/groomerQualificationCertificateChange/save" method="post" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<div class="control-group">
		<label class="control-label">会员号：</label>
		<div class="controls">
			<input type="text" id="memberName" name="memberName" placeholder="会员姓名" class="input-medium required">
			<form:input path="memberCode" htmlEscape="false" maxlength="16" placeholder="会员号"
			            class="input-medium required"/>
			<input id="searchMember" class="btn btn-primary" type="button" value="查" onclick="searchUser()"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">证书来源：</label>
		<div class="controls">
			<form:select path="certificateSource" class="input-xlarge required">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_certificate_change_source')}" itemLabel="label"
				              itemValue="value" htmlEscape="false"/>
			</form:select>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">原证书级别：</label>
		<div class="controls">
			<form:select path="certificateLevel" class="input-xlarge required">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_qualification_level')}" itemLabel="label"
				              itemValue="value" htmlEscape="false"/>
			</form:select>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div id="ckuCertificateLevelDiv" class="control-group">
		<label class="control-label">CKU证书级别：</label>
		<div class="controls">
			<form:select path="ckuCertificateLevel" class="input-xlarge required">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_qualification_level')}" itemLabel="label"
				              itemValue="value" htmlEscape="false"/>
			</form:select>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">比赛犬种：</label>
		<div class="controls">
			<form:input path="breedName" htmlEscape="false" maxlength="64" class="input-xlarge "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">品种类别：</label>
		<div class="controls">
			<form:input path="breedCate" htmlEscape="false" maxlength="64" class="input-xlarge "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">国家：</label>
		<div class="controls">
			<form:input path="country" htmlEscape="false" maxlength="64" class="input-xlarge "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">审查员：</label>
		<div class="controls">
			<form:input path="reviewer" htmlEscape="false" maxlength="64" class="input-xlarge "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">签发日期：</label>
		<div class="controls">
			<input id="issueDate" name="issueDate" type="text" readonly="readonly" maxlength="20"
			       class="input-medium Wdate required"
			       value="<fmt:formatDate value="${groomerQualificationCertificateChange.issueDate}" pattern="yyyy-MM-dd"/>"
			       onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">证书图片：</label>
		<div class="controls">
			<sys:singleImgUpload module="groomerCertificate"
			                     imgId="${groomerQualificationCertificateChange.certificateImg}"
			                     fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*500*1"
			                     successCallback="uploadSuccess"/>
			<form:input path="certificateImg" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
			<!-- 文件上传成功的回调方法 -->
			<script type="text/javascript">
                function uploadSuccess(file, response) {
                    $("#certificateImg").val(response.id);
                }
			</script>
		</div>
	</div>
	<div id="runningNumberDiv" class="control-group">
		<label class="control-label">订单号：</label>
		<div class="controls">
			<form:input path="runningNumber" htmlEscape="false" maxlength="64" class="input-xlarge "/>
		</div>
	</div>
	<div id="paymentStateDiv" class="control-group">
		<label class="control-label">支付状态：</label>
		<div class="controls">
			<form:select path="paymentState" class="input-xlarge ">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value"
				              htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div id="paymentTimeDiv" class="control-group">
		<label class="control-label">支付时间：</label>
		<div class="controls">
			<input name="paymentTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
			       value="<fmt:formatDate value="${groomerQualificationCertificateChange.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
		</div>
	</div>
	<div id="reviewStateDiv" class="control-group">
		<label class="control-label">审核状态：</label>
		<div class="controls">
			<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:review">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value"
					              htmlEscape="false"/>
				</form:select>
			</shiro:hasPermission>
			<shiro:lacksPermission name="groomer:groomerQualificationCertificateChange:review">
				<form:select path="reviewState" class="input-xlarge " disabled="true">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value"
					              htmlEscape="false"/>
				</form:select>
			</shiro:lacksPermission>
		</div>
	</div>
	<div id="reviewTimeDiv" class="control-group">
		<label class="control-label">审核时间：</label>
		<div class="controls">
			<input name="reviewTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
			       value="<fmt:formatDate value="${groomerQualificationCertificateChange.reviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
		</div>
	</div>
	<div id="reviewRemarksDiv" class="control-group">
		<label class="control-label">审核原因：</label>
		<div class="controls">
			<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:review">
				<form:input path="reviewRemarks" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</shiro:hasPermission>
			<shiro:lacksPermission name="groomer:groomerQualificationCertificateChange:review">
				<form:input path="reviewRemarks" htmlEscape="false" maxlength="64" class="input-xlarge "
				            disabled="true"/>
			</shiro:lacksPermission>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">备注信息：</label>
		<div class="controls">
			<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
		</div>
	</div>
	<div class="form-actions">
		<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:edit"><input id="btnSubmit"
		                                                                                      class="btn btn-primary"
		                                                                                      type="button"
		                                                                                      value="保 存"/>&nbsp;</shiro:hasPermission>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>