<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员账户资金收支明细</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/memberAccount/">会员账户资金收支明细</a></li>
		<li><a href="${ctx}/finance/memberAccount/org">地方俱乐部代办明细</a></li>
		<li class="active"><a href="${ctx}/finance/memberAccount/training">美容学校代办明细</a></li>
		<shiro:hasPermission name="finance:memberAccount:recharge"><li><a href="${ctx}/finance/memberAccount/form">会员账户充值</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="memberAccount" action="${ctx}/finance/memberAccount/training" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<div class="alert" role="alert"  style="text-align: center;display: ${noCode?"block":"none"};">请输入要查询的美容学校编号!</div>
			<li><label>流水号：</label>
				<form:input path="runningNumber" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>美容学校编号：</label>
				<form:input path="memberCode" id="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>支付方式：</label>
				<form:select path="paymentWay" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>金额：</label>
				<form:input path="paymentAmount" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>开始时间：</label>
				<input name="paymentTimeStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					   value="<fmt:formatDate value="${memberAccount.paymentTimeStart}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>-
				<input name="paymentTimeEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					   value="<fmt:formatDate value="${memberAccount.paymentTimeEnd}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<div class="alert" role="alert" style="text-align: right;">余额总计：${countPrice}元</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>金额</th>
				<th>部门</th>
				<th>收支类型</th>
				<th>支付方式</th>
				<th>缴费时间</th>
				<th>备注</th>
				<th>操作人</th>
			</tr>
		</thead>
		<tbody>

		<c:forEach items="${page.list}" var="memberAccount">
			<tr>
				<td>
					${fns:escapeHtml(memberAccount.runningNumber)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.memberName)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.paymentAmount)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.chargingItemOfficeName)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.chargingItemName)}
				</td>
				<td>
					${fns:getDictLabel(memberAccount.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<fmt:formatDate value="${memberAccount.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(memberAccount.paymentRemarks)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.updateBy.name)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>