<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>代收代入管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentPayOther/">代收代入明细</a></li>
		<shiro:hasPermission name="finance:paymentPayOther:add"><li class="active"><a href="${ctx}/finance/paymentPayOther/form">代收代入录入</a></li></shiro:hasPermission></ul><br/>
	<form:form id="inputForm" modelAttribute="paymentPayOther" action="${ctx}/finance/paymentPayOther/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">付款人：</label>
			<div class="controls">
				<input name="drawee" id="memberCoded" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control" required title="付款人不能为空！"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtnd" onclick="searchUser('d')">查</button>
                <font id="paymentStated" ></font>
                </span>
			</div>
			<label class="control-label">付款人姓名：</label>
			<div class="controls">
				<input id="named" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
			<label class="control-label">付款人余额：</label>
			<div class="controls">
				<input id="accountBalanced" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">收款人：</label>
			<div class="controls">
				<input name="payee" id="memberCodep" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control" required title="收款人不能为空！"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtnp" onclick="searchUser('p')">查</button>
                <font id="paymentStatep" ></font>
                </span>
			</div>
			<label class="control-label">收款人姓名：</label>
			<div class="controls">
				<input id="namep" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
			<label class="control-label">收款人余额：</label>
			<div class="controls">
				<input id="accountBalancep" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">金额：</label>
			<div class="controls">
				<input name="price" type="number" step="0.01" min="0" htmlEscape="false" maxlength="100" class="form-control" required title="金额应大于0！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费时间：</label>
			<div class="controls">
				<input name="addTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${paymentPayOther.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" required title="缴费时间不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge required" title="备注不能为空！"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="finance:paymentPayOther:add"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
		var localType = null;
		//打开查询用户的弹窗
		function searchUser(type){
			localType = type;
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			var memberp = $("#memberCodep").val();
			var memberd = $("#memberCoded").val();
			if(localType=='p'){
				if(memberd!=null && memberd!=''){
					if(json.memberCode==memberd){
						alertx("付款人与收款人不能为同一人！");
						return;
					}
				}
			}else{
				if(memberp!=null && memberp!=''){
					if(json.memberCode==memberp){
						alertx("付款人与收款人不能为同一人！");
						return;
					}
				}
			}
			$("#name"+localType).val(json.name);
			$("#memberCode"+localType).val(json.memberCode);
			$("#accountBalance"+localType).val(json.accountBalance);
			/* if(json.paymentState==1){
				$("#paymentState"+localType).text('无效');
			}else if(json.paymentState==2){
				$("#paymentState"+localType).text('有效');
				$("#paymentState"+localType).css("color","red");
			}; */

		}
	</script>
</body>
</html>