<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>补扣费用</title>
    <meta name="decorator" content="default"/>
    <style>
        input[type="radio"]{
            margin: 4px 0px;
        }
    </style>
    <script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    form.submit();
                    $("#btnSubmit").attr("disabled","true");
                    setTimeout("$(\"input:disabled\").removeAttr(\"disabled\")",3000);
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                        $('#btnSubmit').removeAttr("disabled");
                    } else {
                        error.insertAfter(element);
                        $('#btnSubmit').removeAttr("disabled");
                    }
                }
            });
        });
        //检验分摊时间是否正确
        function setinstallmentenddate(){
            var  shareSectionStr = $("#isInstallment").val();
            var installmentStartDate = $("#installmentStartDate").val();
            var date = new Date(installmentStartDate);
            date.setMonth(date.getMonth()+parseInt(shareSectionStr));
            var month = date.getMonth() + 1;
            var endtime = date.getFullYear() + '-' + getFormatDate(month);
            $("#installmentEndDate").val(endtime);

        }
        // 日期月份/天的显示，如果是1位数，则在前面加上'0'
        function getFormatDate(arg) {
            if (arg == undefined || arg == '') {
                return '';
            }

            var re = arg + '';
            if (re.length < 2) {
                re = '0' + re;
            }

            return re;
        }

        function changePrice(obj){

            var pricestr = $("#chargingSel option[value="+obj.value+"]").attr("pricestr");
            var isShareStr= $("#chargingSel option[value="+obj.value+"]").attr("isShareStr");
            var shareSectionStr =$("#chargingSel option[value="+obj.value+"]").attr("shareSectionStr");

            var chargingItemName = $("#chargingSel option[value="+obj.value+"]").html();
            var chargingItemId = $("#chargingSel").val();
            $("#price").val(pricestr);
            $("#paymentAmount").val(pricestr);
            //退费且不是报名退费手续费
            if(chargingItemName.indexOf("退费")>0
                && "b196aba404ce4ff2b331d32ba1e3152f" != chargingItemId){
                $("#tuifei").css("display","block");
                $("#paymentRemarks").addClass("required");
            }else{
                $("#tuifei").css("display","none");
                $("#paymentRemarks").removeClass("required");
            }
            //分摊
            if(isShareStr=="1"){
                $("#isShare").css("display","block");
                $("#isSharespan").html("此收费项为分期确认,分期为"+shareSectionStr+"个月,必须添加分期时间！");
                $("#isInstallment").val(shareSectionStr);
                $("#installmentStartDate").addClass("required");
                $("#installmentEndDate").addClass("required");
            }else{
                $("#isShare").css("display","none");
                $("#isSharespan").html("");
                $("#isInstallment").val("0");
                $("#installmentStartDate").removeClass("required");
                $("#installmentEndDate").removeClass("required");
            }
            $('#btnSubmit').removeAttr("disabled");
        }
        function reload(){
            window.location.reload();
        }
        function saveOrder(){
        	layer.load();
        	$("#inputForm").ajaxSubmit({
				dataType: 'json',
				beforeSubmit: function () {
					if (!$("#inputForm").valid()) {
						layer.closeAll('loading');
						return false;
					}
				},
				success: function (data) {
					if (data.rc == 0) {
						layer.msg(data.msg);
						window.location = "${ctx}/finance/paymentRecord?memberCode="+$("#memberCode").val();
					} else {
						layer.msg(data.msg);
						layer.closeAll('loading');
					}
				},
				error: function (err) {
					layer.closeAll('loading');
					layer.msg("操作失败!");
				}
			});
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a onclick="reload()">补扣费用</a></li>
</ul><br/>
<form id="inputForm" action="${ctx}/finance/deductCost/deductCost" method="post" class="form-horizontal">
	<input type="hidden" id="code" name="code" value="${code }">
	    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">会员号：</label>
        <div class="controls">
            <input name="memberCode" id="memberCode" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control input-xlarge"  required="required"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtn" onclick="searchUser()">查</button>
                <font id="paymentState" ></font>
                </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">姓 名：</label>
        <div class="controls">
            <input type="text" readonly="readonly" id="name"  htmlEscape="false" maxlength="100" class="form-control input-xlarge"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">手机号：</label>
        <div class="controls">
            <input id="mobile" type="text" htmlEscape="false" maxlength="100"  class="form-control input-xlarge" readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
            <input name="gender" maxlength="50" class="input-xlarge" type="radio" value="male" disabled="disabled"/>
            <label>男</label>
            <input name="gender" maxlength="50" class="input-xlarge" type="radio" value="female" disabled="disabled"/>
            <label>女</label>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">余额：</label>
        <div class="controls">
            <input type="text" readonly="readonly" id="accountBalance"   class="form-control input-xlarge">
        </div>
    </div>

    <div class="control-group">
        <label class="control-label">选择缴费项目：</label>
        <input type="hidden" name="price" id="price" value="" class="form-control">
        <div class="controls">
          <select class="form-control input-xlarge required" name="chargingItemId" id="chargingSel" onchange="changePrice(this)" style="width: 284px;" title="缴费项目不能为空！">
              <option value="" priceStr="">请选择</option>
              <c:forEach items="${chargingItemList}" var="chargingItem">
                    <option value="${chargingItem.id}" priceStr="${chargingItem.price}" isShareStr="${chargingItem.isShare}" shareSectionStr="${chargingItem.shareSection}">${chargingItem.name} ${chargingItem.price} ${chargingItem.isShare eq '1'?'分摊项目':''}</option>
              </c:forEach>
          </select>

        </div>
    </div>

    <div class="control-group">
        <label class="control-label">选择缴费项目所属业务：</label>
        <div class="controls">
            <select class="form-control input-xlarge required" name="businessMappingId" id="chargingSel2"  style="width: 284px;" title="缴费项目所属业务不能为空！">
                <%--                <option value="" priceStr="">请选择</option>--%>
                <c:forEach items="${bizList}" var="bizItem">
                    <option value="${bizItem.id}" > ${bizItem.subjectName} </option>
                </c:forEach>
            </select>
        </div>
    </div>


    <div class="control-group">
        <label class="control-label">缴费金额：</label>
        <div class="controls">
            <input type="number" min="0" name="paymentAmount" id="paymentAmount" value="0" required title="缴费金额不能为空！" class="form-control input-xlarge"><span id="tuifei" style="display:none;color:red;font-size: 25px;">退费功能将钱转入本会员余额中！</span>
        </div>
    </div>
    <div class="control-group" id="isShare" style="display: none;">

        <label class="control-label">分期确认：</label>
        <div class="controls">
            <input name="isInstallment" id="isInstallment" value="0" type="hidden" />
            <input name="installmentStartDate" id="installmentStartDate" placeholder="请选择开始时间" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate " onclick="WdatePicker({dateFmt:'yyyy-MM',isShowClear:true,onpicked:setinstallmentenddate });"/>
            &nbsp;至&nbsp;
            <input name="installmentEndDate" id="installmentEndDate" placeholder="结束时间" type="text"  readonly="readonly" maxlength="20" class="input-xlarge "/>
            <div style="margin-top:10px;color:red;font-size:22px;" id="isSharespan"></div>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <input type="text" name="paymentRemarks" id="paymentRemarks"  class="form-control input-xlarge">
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="finance:deductCost:deductCost">
        	<input id="btnSubmit" class="btn btn-primary" type="button"  onclick="saveOrder()"  value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form>
<script>
    //打开查询用户的弹窗
    function searchUser(){
        top.layer.open({
            type: 2,
            title: ['会员查询', 'font-size:18px;text-align: center;'],
            shadeClose: false,
            shade: [0.8, '#393D49'],
            maxmin: false, //开启最大化最小化按钮
            area: ['700px', '500px'],
            content: "${ctx}/sys/user/member/search"
        });
    }

    //查询用户完成的回调方法
    this.searchUserCallback = function (json){
        $("#name").val(json.name);
        $("#memberCode").val(json.memberCode);
        $("#mobile").val(json.mobile);
        $("#accountBalance").val(json.accountBalance);
        $("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
        $('#btnSubmit').removeAttr("disabled");
    }
</script>
</body>
</html>