<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function openEditPage(id,birthCode,dogOwenr,createDate,hospitalCode){
			parent.layer.open({
		        type: 2,
		        title: ['新生犬登记审核', 'font-size:18px;text-align: center;'],
		        shadeClose: false,
		        shade: [0.8, '#393D49'],
		        maxmin: false, //开启最大化最小化按钮
		        area: ['560px', '480px'],
		        content: ctx+"/newdogchip/dogChip/review?id="+id,
		        end: function(){
		            if(parent.isYes){
		                var mainF = parent.$("#mainFrame");
		                mainF.contents().find("#searchForm").submit();
		            };
		        }
		    }); 
		};
		function openViewPage(id,birthCode,dogOwenr,createDate,hospitalCode){
            parent.layer.open({
                type: 2,
                title: ['新生犬登记查看', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['560px', '480px'],
                content: ctx+"/newdogchip/dogChip/view?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            }); 
        };
		function changeProcessState(id){
			var msg=confirm("确认要处理该新生犬登记吗？");
		    if(msg==true){
		    	$.ajax({
	                type: "POST",
	                url:"${ctx}/newdogchip/dogChip/process?id="+id,
	                dataType:"json",
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	if(request.status=='403'&&errorThrown=='Forbidden'){
	                		alert("服务器拒绝您的访问，请查看是否存在此功能操作权限！");
	                	} else {
	                		alert("错误代码："+request.status+"，错误描述："+errorThrown);
	                	}
	                },
	                success: function(data) {
	                    if(data.rc==0){
	                        alert("处理成功");
	                        var mainF = parent.$("#mainFrame");
	                        mainF.contents().find("#searchForm").submit();
	                    }else {
	                        alert("错误代码："+data.rc+"错误信息："+data.msg);
	                        parent.isYes = false;
	                    }
	                }
	            });
		    } else {
		    	return;
		    }
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>血统证书号</th>
				<th>身份识别标识</th>
				<th>合作医院</th>
				<th>提交时间</th>
				<th>付款状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogChip">
			<tr>
				<td>
					${fns:escapeHtml(dogChip.birthCode) }
				</td>
                <td>
                    ${fns:escapeHtml(dogChip.dogBirthCertificate.pedigreeCertified) }
                </td>
                <td>
                    ${fns:escapeHtml(dogChip.dogBirthCertificate.identificationFlag) }
                </td>
                <td>
                    ${fns:escapeHtml(dogChip.sysOrg.name) }
                </td>
				<td>
                    <fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
				<td>
				    <c:if test="${dogChip.paymentState==1}"><font color="red">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				    <c:if test="${dogChip.paymentState==2}"><font color="green">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
                <td>
	                <c:if test="${!dogChip.businessRefundState}">
	                	<shiro:hasPermission name="newdogchip:dogChip:delete">
	    					<a href="${ctx}/newdogchip/dogChip/orderDelete?id=${dogChip.id}" onclick="return confirmx('确认要删除该新生犬登记吗？', this.href)">删除</a>
					</shiro:hasPermission>
	                </c:if>
			</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>