<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>国外血统证书编号</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>流程状态</th>
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogPedigreeCertifiedChange">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.breedCnName)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogBreed)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td style="color:${dogPedigreeCertifiedChange.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedChange.paymentState, 'user_payment_state', '')}
				</td>
				<td style="color:#000" title="${fns:escapeHtml(dogPedigreeCertifiedChange.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedChange.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogPedigreeCertifiedChange.reviewState=='0'}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogPedigreeCertifiedChange.id)}')">${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					
					<c:choose>
						<c:when test="${dogPedigreeCertifiedChange.reviewState=='1'&&dogPedigreeCertifiedChange.processState=='0'}">
							<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/resolve?id=${fns:escapeHtml(dogPedigreeCertifiedChange.id)}"
								onclick="return confirmx('确认要处理该证书换发吗？', this.href)">
							${fns:getDictLabel(dogPedigreeCertifiedChange.processState, 'proccess_state', '')}
							</a>
						</c:when>
						<c:when test="${dogPedigreeCertifiedChange.processState=='1'}">
							${fns:getDictLabel(dogPedigreeCertifiedChange.processState, 'proccess_state', '')}
						</c:when>
					</c:choose>
				</td>
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit"><td>
				<c:if test="${!dogPedigreeCertifiedChange.businessRefundState}">
					<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/form?id=${dogPedigreeCertifiedChange.id}">修改</a>
					<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/delete?id=${dogPedigreeCertifiedChange.id}" onclick="return confirmx('确认要删除该证书换发吗？', this.href)">删除</a>
				</c:if>
    				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>