<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>配种证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
	</script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>配种证明编号</th>
				<th>所属地区</th>
				<th>公犬主</th>
				<th>公犬证书号</th>
				<th>母犬主</th>
				<th>母犬证书号</th>
				<th>配种日期</th>
				<th>出生日期</th>
				<th>加急</th>
				<th>支付状态</th>
				<shiro:hasPermission name="dognewborn:dogNewborn:delete"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogNewborn">
			<tr>
				<td>
				    ${fns:escapeHtml(dogNewborn.breedCertifiedCode) }
				</td>
				<td>
					${fns:escapeHtml(dogNewborn.area) }
				</td>
				<td>
					${fns:escapeHtml(dogNewborn.maleDogOwner) }
				</td>
				<td>
                    ${fns:escapeHtml(dogNewborn.malePedigreeCertified) }
                </td>
				<td>
					${fns:escapeHtml(dogNewborn.femaleDogOwner) }
				</td>
				<td>
					${fns:escapeHtml(dogNewborn.femalePedigreeCertified) }
				</td>
				<td>
					<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogNewborn.birthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
				    <c:if test="${dogNewborn.urgent==0}">${fns:getDictLabel(dogNewborn.urgent, 'yes_no', '')}</c:if>
				    <c:if test="${dogNewborn.urgent==1}"><font color="red">${fns:getDictLabel(dogNewborn.urgent, 'yes_no', '')}</font></c:if>
				</td>
				<td>
				    <c:if test="${dogNewborn.paymentState==1}">
				        <font color="red">${fns:getDictLabel(dogNewborn.paymentState, 'user_payment_state', '')}&nbsp;${dogNewborn.price}</font>
				    </c:if>
				    <c:if test="${dogNewborn.paymentState!=1}">
                        <font color="green">${fns:getDictLabel(dogNewborn.paymentState, 'user_payment_state', '')}&nbsp;${dogNewborn.price}</font>
                    </c:if>
                    
                </td>
				<shiro:hasPermission name="dognewborn:dogNewborn:delete"><td>
					<c:if test="${!dogNewborn.businessRefundState}">
	                    	<a href="${ctx}/dognewborn/dogNewborn/orderDelete?id=${dogNewborn.id}" onclick="return confirmx('确认要删除该配种证明申请吗？', this.href)">删除</a>
	                    </c:if>
                </td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>