<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>纯种犬鉴定申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogdnaparentscompare/dogDnaParentsCompare/audit',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("审核成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("审核失败,错误信息："+data.msg);
 						}
 				    });
					closeLoading();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogDnaParentsCompare" class="form-horizontal">
	<form:hidden path="id"/>
	<div class="control-group">
		<label class="control-label">出生证明编号：</label>
		<div class="controls">
				${dogDnaParentsCompare.birthCode}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">血统证书编号：</label>
		<div class="controls">
				${dogDnaParentsCompare.pedigreeCertified}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬名：</label>
		<div class="controls">
				${dogDnaParentsCompare.dogName}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls">
			<fmt:formatDate value="${dogDnaParentsCompare.dogBirthday}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls">
				${fns:getDictLabel(dogDnaParentsCompare.dogGender, 'dog_gender', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">审核状态：</label>
		<div class="controls">
			<form:select id="reviewState" path="reviewState" class="input-medium">
				<form:options items="${fns:getDictList('dna_parents_compare_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">审核意见：</label>
		<div class="controls">
			<form:textarea path="reviewRemarks" rows="3" cols="20" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>