<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>课程资料管理</title>
    <meta name="decorator" content="default"/>
    <style type="text/css">
    	.file-input{
    		margin-bottom: 10px!important;
    	}
    	.file-img{
    		cursor:pointer;
    		width: 16px;
    		height:16px;
    		padding:0px 0px 0px 5px;
    		z-index:10;
    		box-sizing:initial;
    	}
    	body{
			min-height:309px!important;
		}
    </style>
    <script type="text/javascript">
    	var fileObjs = {};
        function uploadedCallback(file,res){
        	$("#coursewareNameGroup").show();
        	var fileHtml = '<div id="'+file.id+'">';
        	fileHtml += '<input type="text" readonly="readonly" id="coursewareName'+file.id+'" name="coursewareName" fileUrl="'+res.fileUrl+'" value="'+file.name+'" title="'+file.name+'" onblur="unEditCoursewareName(this)" maxlength="100" class="input-xlarge file-input" placeholder="默认文件名称，可修改"/>';
        	fileHtml += '<img title="编辑名称" target="coursewareName'+file.id+'" src="${ctxStatic}/img/edit.png" onclick="editCoursewareName(this)" class="file-img" />';
        	fileHtml += '<img title="删除" target="'+file.id+'" src="${ctxStatic}/img/remove.png" onclick="delCoursewareFile(this)" class="file-img" />';
        	fileHtml += '</div>';
        	$("#coursewareNameBody").append(fileHtml);
        	fileObjs[file.id] = file;
        }
        
        function editCoursewareName(obj){
        	var target = $("#"+$(obj).attr("target"));
        	target.attr("readonly",false);
        	var val = target.val();
        	target.val("").focus().val(val);
        }
        
        function unEditCoursewareName(obj){
        	$(obj).attr("readonly",true);
        }
        
		function delCoursewareFile(obj){
			$.jBox.confirm("确认要删除该文件吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					$("#"+$(obj).attr("target")).remove();
					try {
						if($("#coursewareNameBody input[name='coursewareName']").size() == 0){
							$("#coursewareNameGroup").hide();
						}
						var fileId = $(obj).attr("target");
						fileObjs[fileId].setStatus("cancelled","文件被移除");
						delete fileObjs[fileId];
					}catch(err) {
						console.log('捕获到异常：',err); 
					}
				}
			},{buttonsFocus:1,persistent: true});
			$('.jbox-body .jbox-icon').css('top','55px');
        }
		
		function saveCourseware(){
			if($("#thelist").find("p[class='state']").size() > 0 ){
				$.jBox.confirm("您选择的文件还未上传，确定要保存吗？", "系统提示", function(v, h, f){
					if (v == 'ok'){
						saveCoursewareReal();
					}
					return true;
				});
				return false;
			} else {
				saveCoursewareReal();
			}
		}
		
		function saveCoursewareReal(){
			var data = [];
			$("#coursewareNameBody input[name='coursewareName']").each(function(index,obj){
				data.push({"coursewareName":$(obj).val(),"url":$(obj).attr("fileurl")});
			});
			if(data.length < 1){
				$.jBox.alert("请上传的课程资料后保存！");
				return false;
			}
			$.ajax({
                type: "POST",
                url:"${ctx}/appreciation/appreciationCourseware/save",
                contentType: "application/json",
                dataType:"json",
                data:JSON.stringify(data),
                async: false,
                error: function(request, textStatus, errorThrown) {
                	$.jBox.alert("系统错误，请联系管理员！");
                },
                success: function(data) {
                	$.jBox.alert(data.msg,"消息",{submit:function (v, h, f) { 
                		if(data.rc==0){
                    		parent.isRefresh = true
                            parent.layer.closeAll();
                    	}
                	}});
                	
                }
            });
		}
    </script>
</head>
<body>
<ul class="nav nav-tabs"></ul><br/>
<form:form id="inputForm" modelAttribute="appreciationCourseware"
           action="${ctx}/appreciation/appreciationCourseware/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group" id="coursewareNameGroup" style="display: none;">
        <label class="control-label">资料名称：</label>
        <div id="coursewareNameBody" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">资料文件：</label>
        <div class="controls">
        	<sys:ossUpload module="appreciation" duplicate="true" maxCount="10" maxSize="20480" messageTime="2000" successHideFile="true" successCallback="uploadedCallback" ></sys:ossUpload>
        </div>
    </div>
</form:form>
</body>
</html>