<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!-- 使用说明， 通过module决定要传的文件的对应的模块。 successCallback是个js的方法名，是回调函数，可以传出文件信息和服务器的反馈信息 -->
<%@ attribute name="moduleId" type="java.lang.String" required="true" description="上传组件唯一标识" %>
<%@ attribute name="module" type="java.lang.String" required="true" description="文件上传之后的目录，会影响物理文件存储" %>
<%@ attribute name="state" type="java.lang.String" required="false" description="官网是否显示标记位" %>
<%@ attribute name="server" type="java.lang.String" required="false" description="上传服务的地址，不填调用默认地址"%>
<%@ attribute name="imgId" type="java.lang.String" required="true" description="原图片地址" %>
<%@ attribute name="fileSizeLimit" type="java.lang.String" required="true" description="限制文件的上传的总大小" %>
<%@ attribute name="fileSingleSizeLimit" type="java.lang.String" required="true" description="单一的文件大小的限制" %>

<script type="text/javascript" src="${ctxStatic }/webuploader/webuploader.js"></script>
<link rel="stylesheet" href="${ctxStatic }/webuploader/webuploader.css"/>
<link rel="stylesheet" href="${ctxStatic }/webuploader/css/webuploader.img.custom.css"/>

<div class="uploder-container" >
	<input type="hidden" class="uploader-moduleId" value="${moduleId}" />
	<input type="hidden" class="uploader-module" value="${module}" />
	<input type="hidden" class="uploader-state" value="${state}" />
	<input type="hidden" class="uploader-server" value="${server}" />
	<input type="hidden" class="uploader-fileSizeLimit" value="${fileSizeLimit}" />
	<input type="hidden" class="uploader-fileSingleSizeLimit" value="${fileSingleSizeLimit}" />
	<div style="float:left;width:50%;">
		<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
			<center>
				<c:if test="${empty imgId}">
					<img class="previewImg" alt="" src="" style="padding:10px;height:130px;"/>
				</c:if>
				<c:if test="${not empty imgId && fn:startsWith(imgId, 'http')}">
					<img class="previewImg" alt="" src="${imgId}" style="padding:10px;height:130px;"/>
				</c:if>
				<c:if test="${not empty imgId && !fn:startsWith(imgId, 'http')}">
					<img class="previewImg" alt="" src="${ctx}/sys/file/image/${imgId}" style="padding:10px;height:130px;"/>
				</c:if>
			</center>
			<div style="position:relative;color: #cccccc;font-size: 18px;"><center>图片预览</center></div>
		</div>
		
	</div>
	<div style="float:left;width:50%;">
	    <div class="queueList">
	        <div class="placeholder">
	            <div class="filePicker WebUploader-container"></div>
	            <p>或将照片拖到这里</p>
	        </div>
	    </div>
	    <div class="statusBar" style="display:none;">
	        <div class="progress" style="display: none;">
	            <span class="text">0%</span>
	            <span class="percentage" style="width: 0%;"></span>
	        </div><div class="info" style="display:none;">共0张（0B），已上传0张</div>
	        <div class="btns">
	            <div class="filePicker2 WebUploader-container"></div>
	            <div class="uploadBtn state-pedding">开始上传</div>
	        </div>
	    </div>
	</div>
</div>
<script type="text/javascript">
var uploader;
jQuery(function() {
    uploader = new Array();//创建 uploader数组
	// 优化retina, 在retina下这个值是2
    var ratio = window.devicePixelRatio || 1,
    // 缩略图大小
    thumbnailWidth = 110 * ratio,
    thumbnailHeight = 110 * ratio,
    supportTransition = (function(){
        var s = document.createElement('p').style,
        r = 'transition' in s ||
              'WebkitTransition' in s ||
              'MozTransition' in s ||
              'msTransition' in s ||
              'OTransition' in s;
        s = null;
        return r;
    })();
 	// 所有文件的进度信息，key为file id
    var percentages = {};
    
    if ( !WebUploader.Uploader.support() ) {
        alert( '上传组件 不支持您的浏览器！如果你使用的是IE浏览器，请尝试升级 flash 播放器');
        throw new Error( 'WebUploader does not support the browser you are using.' );
    }
    
    $('.uploder-container').each(function(index){
    	var state = 'pedding';
    	// 添加的文件数量
        var fileCount = 0;
        // 添加的文件总大小
        var fileSize = 0;
		var filePicker=$(this).find('.filePicker');//上传按钮实例
		var queueList=$(this).find('.queueList');//拖拽容器实例
		var previewImg=$(this).find('.previewImg');//回显实例
		/* var jxfilePicker=$(this).find('.jxfilePicker');//继续添加按钮实例 */
		var uploadBtn=$(this).find('.uploadBtn');//上传按钮
		var placeHolder=$(this).find('.placeholder');//按钮与虚线框实例
		var statusBar=$(this).find('.statusBar');//再次添加按钮容器实例
		var progress=statusBar.find('.progress');
		var filePicker2=statusBar.find('.filePicker2');
		var info=statusBar.find('.info');//提示信息容器实例
		var moduleId = $(this).find('.uploader-moduleId').val();
		var dataModule = $(this).find('.uploader-module').val();
		var dataState = $(this).find('.uploader-state').val();
		var server = $(this).find('.uploader-server').val();
		if(server==null || server == "" || server == undefined){
			server = '${ctx}/sys/file/upload';
		}
		var fileSizeLimit = $(this).find('.uploader-fileSizeLimit').val();
		var fileSingleSizeLimit = $(this).find('.uploader-fileSingleSizeLimit').val();
		// 图片容器       	
		var queue = $('<ul class="filelist"></ul>').appendTo(queueList);
		//初始化上传实例
        uploader[index] = WebUploader.create({
            pick: {
                id: filePicker,
                label: '点击选择图片'
            },
            dnd: queueList,
            accept: {
                title: 'Images',
                extensions: 'gif,jpg,jpeg,bmp,png',
                mimeTypes: 'image/jpg,image/jpeg,image/png'
            },
            swf: '${ctxStatic}/webuploader/Uploader.swf',
            // 文件接收服务端。
            server: server,
            disableGlobalDnd: true,
            chunked: true,
            fileNumLimit:1,
            //文件总大小的限制
            fileSizeLimit: eval(fileSizeLimit),
            //单一文件的大小的限制
            fileSingleSizeLimit:eval(fileSingleSizeLimit),
            formData:{module:dataModule,state:dataState},
            duplicate :true
        });
        var nowUploader = {};
        nowUploader["uploader"] = uploader[index];
        nowUploader["fileCount"] = fileCount;
        nowUploader["fileSize"] = fileSize;
        nowUploader["filePicker"] = filePicker;
        nowUploader["previewImg"] = filePicker;
        nowUploader["queueList"] = queueList;
        nowUploader["uploadBtn"] = uploadBtn;
        nowUploader["placeHolder"] = placeHolder;
        nowUploader["statusBar"] = statusBar;
        nowUploader["progress"] = progress;
        nowUploader["filePicker2"] = filePicker2;
        nowUploader["moduleId"] = moduleId;
        nowUploader["info"] = info;
        nowUploader["queue"] = queue;
        nowUploader["state"] = state;
       	console.log(nowUploader);
		uploader[index].onUploadProgress = function( file, percentage ) {
	        var $li = $('#'+file.id),
	            $percent = $li.find('.progress span');
	        $percent.css( 'width', percentage * 100 + '%' );
	        percentages[ file.id ][ 1 ] = percentage;
	        updateTotalProgress(nowUploader);
	    };
	
	    uploader[index].onFileQueued = function( file ) {
	        fileCount++;
	        fileSize += file.size;
	        if ( fileCount === 1 ) {
	            placeHolder.addClass( 'element-invisible' );
	            statusBar.show();
	        }
	        addFile(file,nowUploader);
	        setState( 'ready',nowUploader);
	        updateTotalProgress(nowUploader);
	    };
	
	    uploader[index].onFileDequeued = function( file ) {
	        fileCount--;
	        fileSize -= file.size;
	
	        if ( !fileCount ) {
	            setState( 'pedding',nowUploader);
	        }
	
	        removeFile(file,nowUploader);
	        updateTotalProgress(nowUploader);
	
	    };
	    
		//上传成功
		uploader[index].on( 'uploadSuccess', function( file,response ) {
			previewImg.attr("src","${ctx}/sys/file/image/"+response.id);
			if(typeof(uploadSuccessCallback) == "function"){
				uploadSuccessCallback(nowUploader.moduleId,file,response);
			}
		  	uploader[index].removeFile(file,nowUploader);//移除文件
		});
	
		uploader[index].on( 'all', function( type ) {
	        var stats;
	        switch( type ) {
	            case 'uploadFinished':
	                setState( 'confirm',nowUploader);
	                break;
	
	            case 'startUpload':
	                setState( 'uploading',nowUploader);
	                break;
	
	            case 'stopUpload':
	                setState( 'paused',nowUploader);
	                break;
	        }
	    });
	
		uploader[index].onError = function( code ) {
	        if(code == "F_DUPLICATE"){
	        	alert("文件已经被添加了，不能重复添加文件");
	        }else if(code == "F_EXCEED_SIZE"){
	        	alert("文件大小超出了限制");
	        }else if(code == "Q_EXCEED_SIZE_LIMIT"){
	        	alert("文件总大小超出了限制");
	        }else if(code == "Q_EXCEED_NUM_LIMIT"){
	        	alert("文件数量超出了限制，添加文件之前请先删除其他文件");
	        }
	        else{
	        	alert("上传出错");
	        }
	    };
	    
	    nowUploader.uploadBtn.on('click', function() {
	        if ( $(this).hasClass( 'disabled' ) ) {
	            return false;
	        }
	        if ( nowUploader.state === 'ready' ) {
	        	uploader[index].upload();
	        } else if ( nowUploader.state === 'paused' ) {
	        	uploader[index].upload();
	        } else if ( nowUploader.state === 'uploading' ) {
	        	uploader[index].stop();
	        }
	    });
	    
	    nowUploader.info.on( 'click', '.retry', function() {
	        uploader[index].retry();
	    } );

	    nowUploader.info.on( 'click', '.ignore', function() {
	        alert( 'todo' );
	    } );

	    nowUploader.uploadBtn.addClass('state-' + nowUploader.state );
	    
	    updateTotalProgress(nowUploader);
	    
    });
    
    
    function setState(val,nowUploader) {
        var file, stats;
        if ( val === nowUploader.state ) {
            return;
        }
        nowUploader.uploadBtn.removeClass( 'state-' + nowUploader.state );
        nowUploader.uploadBtn.addClass( 'state-' + val );
        nowUploader.state = val;
        switch ( nowUploader.state ) {
            case 'pedding':
            	nowUploader.placeHolder.removeClass( 'element-invisible' );
            	nowUploader.queue.parent().removeClass('filled');
            	nowUploader.queue.hide();
            	nowUploader.statusBar.addClass( 'element-invisible' );
                nowUploader.uploader.refresh();
                break;

            case 'ready':
            	nowUploader.placeHolder.addClass( 'element-invisible' );
            	nowUploader.filePicker2.removeClass( 'element-invisible');
                nowUploader.queue.parent().addClass('filled');
                nowUploader.queue.show();
                nowUploader.statusBar.removeClass('element-invisible');
                nowUploader.uploader.refresh();
                break;

            case 'uploading':
            	nowUploader.filePicker2.addClass( 'element-invisible' );
                nowUploader.progress.show();
                nowUploader.uploadBtn.text( '暂停上传' );
                break;

            case 'paused':
            	nowUploader.progress.show();
                nowUploader.uploadBtn.text( '继续上传' );
                break;
 
            case 'confirm':
            	nowUploader.progress.hide();
                //$upload.text( '开始上传' ).addClass( 'disabled' );
                nowUploader.uploadBtn.text( '开始上传' );
                stats = nowUploader.uploader.getStats();
                if ( stats.successNum && !stats.uploadFailNum ) {
                    setState( 'finish',nowUploader);
                    return;
                }
                break;
            case 'finish':
                stats = nowUploader.uploader.getStats();
                if ( stats.successNum ) {
                   
                } else {
                    // 没有成功的图片，重设
                    nowUploader.state = 'done';
                    location.reload();
                }
                break;
        }
        updateStatus(nowUploader);
    }
    
    function updateStatus(nowUploader) {
        var text = '', stats;
        if ( nowUploader.state === 'ready' ) {
            text = '选中' + nowUploader.fileCount + '张图片，共' +
                    WebUploader.formatSize(nowUploader.fileSize ) + '。';
        } else if ( nowUploader.state === 'confirm' ) {
            stats = nowUploader.uploader.getStats();
            if ( stats.uploadFailNum ) {
                text = '已成功上传' + stats.successNum+ '张照片至XX相册，'+
                    stats.uploadFailNum + '张照片上传失败，<a class="retry" href="#">重新上传</a>失败图片或<a class="ignore" href="#">忽略</a>'
            }
        } else {
            stats = nowUploader.uploader.getStats();
            text = '共' + nowUploader.fileCount + '张（' +
                    WebUploader.formatSize( nowUploader.fileSize )  +
                    '），已上传' + stats.successNum + '张';

            if ( stats.uploadFailNum ) {
                text += '，失败' + stats.uploadFailNum + '张';
            }
        }
        nowUploader.info.html( text );
    }
    
    // 当有文件添加进来时执行，负责view的创建
    function addFile( file,nowUploader) {
        var $li = $( '<li id="' + file.id + '">' +
                '<p class="title">' + file.name + '</p>' +
                '<p class="imgWrap"></p>'+
                '<p class="progress"><span></span></p>' +
                '</li>' ),

            $btns = $('<div class="file-panel">' +
                '<span class="cancel">删除</span>' +
                '<span class="rotateRight">向右旋转</span>' +
                '<span class="rotateLeft">向左旋转</span></div>').appendTo( $li ),
            $prgress = $li.find('p.progress span'),
            $wrap = $li.find( 'p.imgWrap' ),
            $info = $('<p class="error"></p>'),

            showError = function( code ) {
                switch( code ) {
                    case 'exceed_size':
                        text = '文件大小超出';
                        break;

                    case 'interrupt':
                        text = '上传暂停';
                        break;

                    default:
                        text = '上传失败，请重试';
                        break;
                }

                $info.text( text ).appendTo( $li );
            };

        if ( file.getStatus() === 'invalid' ) {
            showError( file.statusText );
        } else {
            // @todo lazyload
            $wrap.text( '预览中' );
            nowUploader.uploader.makeThumb( file, function( error, src ) {
                if ( error ) {
                    $wrap.text( '不能预览' );
                    return;
                }
                var img = $('<img src="'+src+'">');
                $wrap.empty().append( img );
            }, thumbnailWidth, thumbnailHeight );

            percentages[ file.id ] = [ file.size, 0 ];
            file.rotation = 0;
        }

        file.on('statuschange', function( cur, prev ) {
            if ( prev === 'progress' ) {
                $prgress.hide().width(0);
            } else if ( prev === 'queued' ) {
                $li.off( 'mouseenter mouseleave' );
                $btns.remove();
            }

            // 成功
            if ( cur === 'error' || cur === 'invalid' ) {
                console.log( file.statusText );
                showError( file.statusText );
                percentages[ file.id ][ 1 ] = 1;
            } else if ( cur === 'interrupt' ) {
                showError( 'interrupt' );
            } else if ( cur === 'queued' ) {
                percentages[ file.id ][ 1 ] = 0;
            } else if ( cur === 'progress' ) {
                $info.remove();
                $prgress.css('display', 'block');
            } else if ( cur === 'complete' ) {
                $li.append( '<span class="success"></span>' );
            }
            $li.removeClass( 'state-' + prev ).addClass( 'state-' + cur );
        });

        $li.on( 'mouseenter', function() {
            $btns.stop().animate({height: 30});
        });

        $li.on( 'mouseleave', function() {
            $btns.stop().animate({height: 0});
        });
        $btns.on( 'click', 'span', function() {
            var index = $(this).index(),
                deg;
            switch ( index ) {
                case 0:
                	nowUploader.uploader.removeFile(file,nowUploader);
                    return;

                case 1:
                    file.rotation += 90;
                    break;

                case 2:
                    file.rotation -= 90;
                    break;
            }
            if ( supportTransition ) {
                deg = 'rotate(' + file.rotation + 'deg)';
                $wrap.css({
                    '-webkit-transform': deg,
                    '-mos-transform': deg,
                    '-o-transform': deg,
                    'transform': deg
                });
            } else {
                $wrap.css( 'filter', 'progid:DXImageTransform.Microsoft.BasicImage(rotation='+ (~~((file.rotation/90)%4 + 4)%4) +')');
            }
        });
        $li.appendTo( nowUploader.queue );
    }
    
 	// 负责view的销毁
    function removeFile(file,nowUploader) {
        var $li = $('#'+file.id);
        delete percentages[ file.id ];
        updateTotalProgress(nowUploader);
        $li.off().find('.file-panel').off().end().remove();
    }

    function updateTotalProgress(nowUploader) {
        var loaded = 0,
            total = 0,
            spans = nowUploader.progress.children(),
            percent;

        $.each( percentages, function( k, v ) {
            total += v[ 0 ];
            loaded += v[ 0 ] * v[ 1 ];
        } );

        percent = total ? loaded / total : 0;
        spans.eq( 0 ).text( Math.round( percent * 100 ) + '%' );
        spans.eq( 1 ).css( 'width', Math.round( percent * 100 ) + '%' );
        updateStatus(nowUploader);
    }
});
</script>
