package com.ufida.api.service;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ufida.api.request.VoucherAddRequest;
import com.ufida.api.response.UfidaSyncResponse;

import openapi4j.commons.TokenManager;
import openapi4j.exception.OpenAPIException;
import openapi4j.model.Record;
import openapi4j.platform.TradeService;
import openapi4j.service.VoucherService;
import openapi4j.util.HttpUtil;

@Service
public class UfidaVoucherSyncService extends VoucherService{
	
	private static final long serialVersionUID = -2572121464977236476L;
	
	final static Logger logger = LogManager.getLogger(VoucherService.class);
	
	public UfidaSyncResponse syncVoucher(VoucherAddRequest request) {
		UfidaSyncResponse resp = new UfidaSyncResponse();
		try {
			JSONObject jsonObj = this.add(JSONObject.toJSONString(request), "ChongAiWG");
			resp.setCode(jsonObj.getString("errcode"));
			resp.setMessage(jsonObj.getString("errcode"));
			System.out.println("========================");
			System.out.println(jsonObj.toJSONString());
			System.out.println("========================");
		} catch (OpenAPIException e) {
			resp.setCode(e.getErrcode());
			resp.setMessage(e.getMessage());
			e.printStackTrace();
		}
		return resp;
	}
	
	@Override
	public JSONObject add(String jsonBody, String to_account) throws OpenAPIException {
	        JSONObject record;
	        try {
	            String tradeId = TradeService.getTradeId();
	            Map<String, String> paramMap = new HashMap<>();
	            paramMap.put("to_account", to_account);
	            paramMap.put("tradeid", tradeId);
	            paramMap.put("sync","1");
	            String url = this.createURL("voucher/add", paramMap);
	            logger.debug(url);
	            String resultStr = HttpUtil.post(url, jsonBody);
	            logger.debug(resultStr);
	            record = Record.parseObject(resultStr);
//	            JSONObject resultRecord = Record.parseObject(resultStr);
//	            Thread.sleep(3000);
//	            record = Record.parseObject(HttpUtil.get(resultRecord.getString("url")));
	        } catch (Exception e) {
	        	OpenAPIException ex = new OpenAPIException(e.getMessage(), e);
	        	ex.setErrcode("1");
	        	ex.setErrmsg(e.getMessage());
	            throw ex;
	        }
	        return record;
	    }

}
