package com.cku.subsystem.dog;

import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.dao.AssociationDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.AreaService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 证书换发Controller
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/subSystem/dogPedigreeCertifiedChange")
public class SubDogPedigreeCertifiedChangeController extends BaseController {

	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private AssociationDao associationDao;
	@Autowired
	private AreaService areaService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private LoginServerService loginServerService;

	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}

	@ModelAttribute
	public DogPedigreeCertifiedChange get(@RequestParam(required=false) String id) {
		DogPedigreeCertifiedChange entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogPedigreeCertifiedChangeService.get(id);
		}
		if (entity == null){
			entity = new DogPedigreeCertifiedChange();
		}
		return entity;
	}

	@RequestMapping(value = {"list", ""})
	public String list(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogPedigreeCertifiedChange> page = dogPedigreeCertifiedChangeService.findPage(new Page<DogPedigreeCertifiedChange>(request, response), dogPedigreeCertifiedChange);
		for(DogPedigreeCertifiedChange po:page.getList()){
			po.setBusinessState(dogPedigreeCertifiedChangeService.getBusinessState(po));
			po.setIsCanCancel(dogPedigreeCertifiedChangeService.isCanCancel(po)==false?"0":"1");
		}
		model.addAttribute("page", page);
		model.addAttribute("newBusinessTimeMillis", DogPedigreeCertifiedChangeService.newBusinessTimeMillis);
		return "subSystem/"+getUrlByUserType()+"/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeList";
	}

	@RequestMapping(value = "form")
	public String form(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		return "subSystem/"+getUrlByUserType()+"/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeForm";
	}
	@RequestMapping(value = "print")
	public String print(DogPedigreeCertifiedChange print, Model model,HttpServletRequest request) {
		DogPedigreeCertifiedChange ogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(print.getId());
		Dog dog = dogService.getByPedigreeCertifiedEn(ogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		String path = dogService.processPrintBusiness(dog, model, Boolean.TRUE);
		// 证书换发打印后标记为已完成
		ogPedigreeCertifiedChange.setIsFinish("1");
		dogPedigreeCertifiedChangeService.save(ogPedigreeCertifiedChange);
		return path;
	}
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogPedigreeCertifiedChange resetPrint, RedirectAttributes redirectAttributes) {
		DogPedigreeCertifiedChange ogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService
				.get(resetPrint.getId());
		Dog dog = dogService.getByPedigreeCertifiedEn(ogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		dogService.resetPrint(dog.getId());
		addMessage(redirectAttributes, "重置打印成功");
		return "redirect:/subSystem/dogPedigreeCertifiedChange/?repage";
	}
}