package com.cku.subsystem.dog;

import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogFrozenSemen;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogFrozenSemenService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.List;

/**
 * 犬只冷冻精子Controller
 *
 * @author lgl
 * @version 2017-08-24
 */
@Controller
@RequestMapping(value = "/subSystem/dogFrozenSemen")
public class SubDogFrozenSemenController extends BaseController {

    @Autowired
    private DogFrozenSemenService dogFrozenSemenService;
    @Autowired
    private DogDao dogDao;
    @Autowired
    private DogSemenDao dogSemenDao;

	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
    @ModelAttribute
    public DogFrozenSemen get(@RequestParam(required = false) String id) {
        DogFrozenSemen entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogFrozenSemenService.get(id);
        }
        if (entity == null) {
            entity = new DogFrozenSemen();
        }
        return entity;
    }

    @RequestMapping(value = {"list", ""})
    public String list(DogFrozenSemen dogFrozenSemen, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogFrozenSemen> page = dogFrozenSemenService.findPage(new Page<DogFrozenSemen>(request, response), dogFrozenSemen);
        model.addAttribute("page", page);
        return "subSystem/"+getUrlByUserType()+"/dog/dogfrozensemen/dogFrozenSemen" + dogFrozenSemen.getBusinessType() + "List";
    }
    @RequestMapping(value = "form")
    public String form(DogFrozenSemen po, Model model) {
        Dog dog = dogDao.get(po.getDogId());
        po.setDog(dog);
        model.addAttribute("dogFrozenSemen", po);
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        model.addAttribute("dogSemenList", dogSemenList);
        return "subSystem/"+getUrlByUserType()+"/dog/dogfrozensemen/dogFrozenSemenForm";
    }
}