package com.cku.restful.v2.breeder.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.breeder.service.RestBannerService;
import com.cku.restful.v1.breeder.service.RestCityService;
import com.cku.restful.v1.breeder.service.RestStudDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v2.breeder.service.RestStudDogServiceV2;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/api/v2/open/breeder")
public class OpenBreederControllerV2 extends BaseRestController {

    @Autowired
    private RestStudDogServiceV2 restStudDogServiceV2;

    /**
     * @description: 种公信息详情接口
     * @author: laiguanglong
     * @date: 2017/10/17 10:11
     */
    @RequestMapping(value = "/studDog/{id}", method = RequestMethod.GET)
    public void get(@PathVariable("id") String id, HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogServiceV2.get(id, request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 种公其他信息详情接口
     * @author: laiguanglong
     * @date: 2017/10/17 10:11
     */
    @RequestMapping(value = "/studDogOtherInfo/{id}", method = RequestMethod.GET)
    public void getOtherInfo(@PathVariable("id") String id, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogServiceV2.getOtherInfo(id);
        ServletUtils.writeResponse(response, result);
    }
}