/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.trainschool.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.trainschool.model.RestTrainingInstitution;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 合作学校Service
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class RestTrainingInstitutionService {
	
	@Autowired
	public TrainingInstitutionDao trainingInstitutionDao;

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String schoolType = request.getParameter("schoolType");
		String displayOnWeb = request.getParameter("displayOnWeb");
		// 参数校验
		if(StringUtils.isBlank(schoolType)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"机构类型为空");
		}
		TrainingInstitution example = new TrainingInstitution();
		example.setDisplayOnWeb(displayOnWeb);
		// 查询并组装返回对象
		List<TrainingInstitution> list = null;
		if("1".equals(schoolType)){
			list = trainingInstitutionDao.findGroomerList(example);
		}else if ("2".equals(schoolType)){
			list = trainingInstitutionDao.findHandlerList(example);
		}
		List<RestTrainingInstitution> restList = new ArrayList<>();
		if(list != null && list.size()>0) {
			for (TrainingInstitution trainingInstitution : list) {
				RestTrainingInstitution vo = new RestTrainingInstitution();
				BeanUtil.copyProperties(vo, trainingInstitution, "yyyy-MM-dd HH:mm");
				vo.setSchoolNameCn(StringEscapeUtils.unescapeHtml4(vo.getSchoolNameCn()));
				restList.add(vo);
			}
		}
		return new RESTResponse("list", new PageBeanResult<>(
				restList, (long)restList.size()));
	}

	/**
	 *
	 * @description: CKU官网查询培训学校信息的接口
	 * schoolType:1为美容；2为牵犬；3为训犬
	 * 1、7  美容  2 牵犬   3456  训犬
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午3:20:26
	 */
	public RESTResponse getTrainingInstitution(HttpServletRequest request){
		//获取参数
		String schoolTypeString = request.getParameter("schoolType");
		String province = request.getParameter("province");
		Integer pageNoInt = ServletUtils.getParameterInt(request, "pageNo",1);//页数
		Integer pageSizeInt = ServletUtils.getParameterInt(request, "pageSize",10);//页码
		//非空检验
		if(StringUtils.isBlank(schoolTypeString)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"培训机构类型为空");
		}
		String[] schoolTypeStringArray = schoolTypeString.split(",");
		StringBuilder sb = new StringBuilder();
		for(String schoolType:schoolTypeStringArray){
			if(!"1".equals(schoolType)
					&&!"2".equals(schoolType)
					&&!"3".equals(schoolType)){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"培训机构类型只能为1，2，3");
			}
			if("1".equals(schoolType)){
				sb.append("1,7,");
			}else if("2".equals(schoolType)){
				sb.append("2,");
			}else if("3".equals(schoolType)){
				sb.append("3,4,5,6,");
			}
		}
		sb.deleteCharAt(sb.length()-1);
		String schoolType = "("+sb.toString()+")";
		List<TrainingInstitution> trainingInstitutionList = trainingInstitutionDao.getTrainingInstitution(schoolType,province,(pageNoInt-1)*pageSizeInt,pageSizeInt);
		List<RestTrainingInstitution> list = new ArrayList<RestTrainingInstitution>();
		for (TrainingInstitution trainingInstitution : trainingInstitutionList) {
			RestTrainingInstitution vo = new RestTrainingInstitution();
			BeanUtil.copyProperties(vo, trainingInstitution, "yyyy-MM-dd HH:mm");
			vo.setSchoolType(getSchoolType(trainingInstitution,province));
			list.add(vo);
		}
		long count = trainingInstitutionDao.getTrainingInstitutionCount(schoolType,province);
		return new RESTResponse("data", new PageBeanResult<RestTrainingInstitution>(list, count));
	}

	/**
	 * @description: 返回处理后的schoolType字段
	 * schoolType:1为美容；2为牵犬；3为训犬
	 * 1、7  美容  2 牵犬   3456  训犬
	 * @author: laiguanglong
	 * @date: 2017/7/20 18:34
	 */
	private String getSchoolType(TrainingInstitution trainingInstitution,String province){
		JSONObject jo = new JSONObject();
		//三大类型
		StringBuilder sb1 = new StringBuilder();
		List<String> trainingInstitutionSchoolTypeList = trainingInstitutionDao.getTrainingInstitutionSchoolTypeList(trainingInstitution.getSchoolNameCn(),trainingInstitution.getTelephone(),trainingInstitution.getAddress(),province);
		if(trainingInstitutionSchoolTypeList.contains("1")||trainingInstitutionSchoolTypeList.contains("7")){
			sb1.append("美容,");
		}
		if(trainingInstitutionSchoolTypeList.contains("2")){
			sb1.append("牵犬,");
		}
		if(trainingInstitutionSchoolTypeList.contains("3")
				||trainingInstitutionSchoolTypeList.contains("4")
				||trainingInstitutionSchoolTypeList.contains("5")
				||trainingInstitutionSchoolTypeList.contains("6")){
			sb1.append("训犬,");
		}
		sb1.deleteCharAt(sb1.length()-1);
		jo.put("schoolType1",sb1.toString());
		//七小类型
		StringBuilder sb2 = new StringBuilder();
		for(String schoolType:trainingInstitutionSchoolTypeList){
			sb2.append(DictUtils.getDictLabel(schoolType,"school_type","")+",");
		}
		sb2.deleteCharAt(sb2.length()-1);
		jo.put("schoolType2",sb2.toString());
		//返回
		return jo.toString();
	}
}