package com.cku.restful.v1.sys.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import org.springframework.util.CollectionUtils;

import lombok.Data;

@Data
public class OCRResult implements Serializable {

	private static final long serialVersionUID = -694777872433990683L;

	private OCRMessage message;

	private List<OCRAccountInfo> accountinfo;

	@Override
	public String toString() {
		if (Objects.nonNull(message) && message.getStatus() == 0 && !CollectionUtils.isEmpty(accountinfo)) {
			StringBuilder sb = new StringBuilder();
			sb.append("祥云OCR实名认证余数查询成功，其中");
			accountinfo.forEach(info->{
				sb.append(info.getDesc()).append("剩余").append(info.getContent()).append("条,");
			});
			return sb.delete(sb.length()-1,sb.length()).toString();
		} else if (Objects.isNull(message)) {
			return "祥云OCR实名认证余数查询失败，返回结果数据为空";
		} else if (message.getStatus() == 0 && CollectionUtils.isEmpty(accountinfo)) {
			return "祥云OCR实名认证余数查询成功，未获取到余数结果";
		} else {
			return "祥云OCR实名认证余数查询失败，未知结果";
		}
	}

}
