package com.cku.restful.v1.show.service;

import com.cku.core.RESTResponse;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.show.dao.ShowReportInfoDao;
import com.cku.oa.show.entity.*;
import com.cku.oa.show.service.ShowJudgeService;
import com.cku.oa.show.service.ShowReportScoreService;
import com.cku.oa.show.service.ShowResultsService;
import com.cku.oa.sys.dao.FciDogDao;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.restful.v1.show.model.CKUShowReportInfo;
import com.cku.restful.v1.show.model.ShowResultBreedGroup;
import com.cku.restful.v1.show.model.ShowResultByGroupResponse;
import com.cku.restful.v1.show.model.ShowResultDogInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.BaseEntity;
import com.thinkgem.jeesite.common.utils.DateUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
public class CKUShowReportInfoService {
	@Autowired
	private ShowReportInfoDao dao;
	@Autowired
	private ShowReportScoreService showReportScoreService;
	@Autowired
	private ShowJudgeService showJudgeService;
	@Autowired
	public ChildShowsDao childShowsDao;
	@Autowired
	public ShowResultsService showResultsService;
	@Autowired
	private FciDogDao fciDogDao;

	public RESTResponse getChildListByMainId(String mainId) {
		HashMap<String, List<CKUShowReportInfo>> map = new HashMap<>();
		String[] numberStrs = {"一", "二", "三", "四", "五", "六", "七", "八", "九", "十", 
				"十一", "十二", "十三", "十四", "十五", "十六", "十七", "十八", "十九", "二十", 
				"二十一", "二十二", "二十三", "二十四", "二十五", "二十六", "二十七", "二十八", "二十九", "三十"};
		//1，从子赛事表中查出所有子赛事
		List<ChildShows> childList = childShowsDao.getByMainShowId(mainId);
		//2，查询已经录入的赛事播报信息
		List<ShowReportInfo> reportInfoList = dao.getChildListByMainId(mainId);
		for (int i = 0; i < childList.size(); i++) {
			ChildShows childShows = childList.get(i);
			if (!"0".equals(childShows.getShowRules())) {
				continue;
			}
			String key = DateUtils.formatDate(childShows.getStartTime(), "yyyy-MM-dd");
			List<CKUShowReportInfo> restInfoList = map.getOrDefault(key, Lists.newArrayList());
			String insertReportId = reportInfoList.stream()
					.filter(showReportInfo -> childShows.getShowCode().equals(showReportInfo.getShowCode()))
					.map(BaseEntity::getId)
					.findFirst()
					.orElse(null);
			String shortName = "第" + (i<29?numberStrs[i]:"") + "场" + "(" + ("0".equals(childShows.getCacType()) ? "CAC" : "CACIB") + ")";
			restInfoList.add(new CKUShowReportInfo(insertReportId, childShows.getShowCode(), childShows.getShowName(), childShows.getStartTime(), childShows.getEndTime(), shortName));

			map.putIfAbsent(key, restInfoList);
		}
		return new RESTResponse("data", map);
	}

	public RESTResponse getShowReportInfoById(String reportId) {
		HashMap<String, Object> result = Maps.newHashMap();
		//赛事信息
		ShowReportInfo showReportInfo = dao.get(reportId);
		result.put("id", showReportInfo.getId());
		//裁判信息
		List<String> judgeIdList = Stream.of(showReportInfo.getJudgeId().split(","))
				.collect(Collectors.toList());
		List<String> judgePicList = Stream.of(showReportInfo.getJudgePic().split(","))
				.collect(Collectors.toList());
		for (int i = 1; i <= judgeIdList.size(); i++) {
			ShowJudge showJudge = showJudgeService.get(judgeIdList.get(i-1));
			String judgeNameTag = "judgeName";
			String citizenshipTag = "citizenship";
			String judgePicTag = "judgePic";
			if (i > 1) {
				judgeNameTag +=i;
				citizenshipTag +=i;
				judgePicTag +=i;
			}
			result.put(judgeNameTag, showJudge == null ? null : StringEscapeUtils.unescapeHtml4(showJudge.getJudgeName()));
			result.put(citizenshipTag, showJudge == null ? null : showJudge.getCitizenship());
			if(judgePicList.size() >= i ) {
				result.put(judgePicTag, judgePicList.get(i - 1));
			}
		}

		//成绩信息
		ShowReportScore bis1 = StringUtils.isBlank(showReportInfo.getBis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis1Order());
		ShowReportScore bis2 = StringUtils.isBlank(showReportInfo.getBis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis2Order());
		ShowReportScore bis3 = StringUtils.isBlank(showReportInfo.getBis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis3Order());
		ShowReportScore bis4 = StringUtils.isBlank(showReportInfo.getBis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis4Order());
		ShowReportScore jbis1 = StringUtils.isBlank(showReportInfo.getJbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis1Order());
		ShowReportScore jbis2 = StringUtils.isBlank(showReportInfo.getJbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis2Order());
		ShowReportScore jbis3 = StringUtils.isBlank(showReportInfo.getJbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis3Order());
		ShowReportScore jbis4 = StringUtils.isBlank(showReportInfo.getJbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis4Order());
		ShowReportScore pbis1 = StringUtils.isBlank(showReportInfo.getPbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis1Order());
		ShowReportScore pbis2 = StringUtils.isBlank(showReportInfo.getPbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis2Order());
		ShowReportScore pbis3 = StringUtils.isBlank(showReportInfo.getPbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis3Order());
		ShowReportScore pbis4 = StringUtils.isBlank(showReportInfo.getPbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis4Order());
		ShowReportScore bbis1 = StringUtils.isBlank(showReportInfo.getBbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis1Order());
		ShowReportScore bbis2 = StringUtils.isBlank(showReportInfo.getBbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis2Order());
		ShowReportScore bbis3 = StringUtils.isBlank(showReportInfo.getBbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis3Order());
		ShowReportScore bbis4 = StringUtils.isBlank(showReportInfo.getBbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis4Order());

		result.put("bisPic", showReportInfo.getBisPic());
		result.put("bis1Pic", showReportInfo.getBis1Pic());
		setHashMap("bis1", bis1, result);
		result.put("bis2Pic", showReportInfo.getBis2Pic());
		setHashMap("bis2", bis2, result);
		result.put("bis3Pic", showReportInfo.getBis3Pic());
		setHashMap("bis3", bis3, result);
		result.put("bis4Pic", showReportInfo.getBis4Pic());
		setHashMap("bis4", bis4, result);

		result.put("jbisPic", showReportInfo.getJbisPic());
		result.put("jbis1Pic", showReportInfo.getJbis1Pic());
		setHashMap("jbis1", jbis1, result);
		result.put("jbis2Pic", showReportInfo.getJbis2Pic());
		setHashMap("jbis2", jbis2, result);
		result.put("jbis3Pic", showReportInfo.getJbis3Pic());
		setHashMap("jbis3", jbis3, result);
		result.put("jbis4Pic", showReportInfo.getJbis4Pic());
		setHashMap("jbis4", jbis4, result);

		result.put("pbisPic", showReportInfo.getPbisPic());
		result.put("pbis1Pic", showReportInfo.getPbis1Pic());
		setHashMap("pbis1", pbis1, result);
		result.put("pbis2Pic", showReportInfo.getPbis2Pic());
		setHashMap("pbis2", pbis2, result);
		result.put("pbis3Pic", showReportInfo.getPbis3Pic());
		setHashMap("pbis3", pbis3, result);
		result.put("pbis4Pic", showReportInfo.getPbis4Pic());
		setHashMap("pbis4", pbis4, result);

		result.put("bbisPic", showReportInfo.getBbisPic());
		result.put("bbis1Pic", showReportInfo.getBbis1Pic());
		setHashMap("bbis1", bbis1, result);
		result.put("bbis2Pic", showReportInfo.getBbis2Pic());
		setHashMap("bbis2", bbis2, result);
		result.put("bbis3Pic", showReportInfo.getBbis3Pic());
		setHashMap("bbis3", bbis3, result);
		result.put("bbis4Pic", showReportInfo.getBbis4Pic());
		setHashMap("bbis4", bbis4, result);
		return new RESTResponse("data", result);
	}

	public void setHashMap(String type, ShowReportScore score, HashMap<String, Object> map) {
		if (score == null) {
			map.put(type + "DogName", null);
			map.put(type + "TypeZh", null);
			map.put(type + "TypeEn", null);
			map.put(type + "DogSex", null);
			map.put(type + "DogOwnerZh", null);
			map.put(type + "OwnerNameEn", null);
			map.put(type + "OtherResult", null);
		} else {
			map.put(type + "DogName", score.getDogName());
			map.put(type + "TypeZh", score.getDogTypeZh());
			map.put(type + "TypeEn", score.getDogTypeEn());
			map.put(type + "DogSex", score.getDogSex());
			map.put(type + "DogOwnerZh", score.getDogOwnerZh());
			map.put(type + "OwnerNameEn", score.getDogOwnerEh());
			map.put(type + "OtherResult", score.getOtherResult());
		}

	}

	@Transactional(readOnly = false)
	public RESTResponse look(String reportId) {
		dao.look(reportId);
		return new RESTResponse();
	}

	/**
	 * 获得全部成绩
	 *
	 * @param groupStr 0成犬组;1青年组;2幼犬组;3特幼组;4老年组;5BBE组;6OHC组;
	 * @author yuanshuai
	 * @date 2021/6/2 11:20
	 */
	public RESTResponse getShowReportAllScoreById(String id, String groupStr) {
		String[] bisEqStr = {"BIS", "JBIS", "PBIS", "BPBIS", "VBIS", "BBE-BIS", "OHC-BIS"};
		String[] bigEqStr = {"BIG", "JBIG", "PBIG", "BPBIG", "VBIG", "BBE-BIG", "OHC-BIG"};
		int groupInt = Integer.parseInt(groupStr);
		ShowResultByGroupResponse response = new ShowResultByGroupResponse();
		ShowReportInfo showReportInfo = dao.get(id);
		//获取对应组BIS成绩
		List<ShowResults> bisResultList = showResultsService.findAllBISByShowCode(showReportInfo.getShowCode());
		bisResultList.forEach(results -> {
			if (results.getResultBis().startsWith(bisEqStr[groupInt])
					|| results.getResultBbeBis().startsWith(bisEqStr[groupInt])
					|| results.getResultOhcBis().startsWith(bisEqStr[groupInt])) {
				ShowResultDogInfo resultResp = new ShowResultDogInfo(results);
				if ("5".equals(groupStr)) {
					resultResp.setResult(results.getResultBbeBis());
				} else if ("6".equals(groupStr)) {
					resultResp.setResult(results.getResultOhcBis());
				} else {
					resultResp.setResult(results.getResultBis());
				}
				response.getBisList().add(resultResp);
			}
		});
		//生成所有犬种组
		List<HashMap<String, Object>> fciGroupList = fciDogDao.getFciGroup();
		fciGroupList.forEach(map -> {
			String groupNameCn = (String) map.get("chinese_group_name");
			String groupCode = (String) map.get("group_no");
			groupCode = groupCode.startsWith("0") ? groupCode.substring(1) : groupCode;
			ShowResultBreedGroup group = new ShowResultBreedGroup();
			group.setGroupCode(groupCode);
			group.setGroupName(groupNameCn);
			response.getGroupList().add(group);
		});
		//获取所有成绩并分组
		List<ShowResults> allResultsList = showResultsService.findAllResultByAgeGroup(showReportInfo.getShowCode(), groupStr);
		allResultsList.forEach(results -> {
			ShowResultBreedGroup group = response.getGroupList().stream()
					.filter(showResultBreedGroup -> showResultBreedGroup.getGroupCode().equals(results.getDogBreedGroup()))
					.findFirst()
					.orElse(null);
			if (group == null) {
				group = new ShowResultBreedGroup();
				group.setGroupCode(results.getDogBreedGroup());
				response.getGroupList().add(group);
			}
			if (results.getResultBig().startsWith(bigEqStr[groupInt])
					|| results.getResultBbeBig().startsWith(bigEqStr[groupInt])
					|| results.getResultOhcBig().startsWith(bigEqStr[groupInt])) {
				ShowResultDogInfo bigResultResp = new ShowResultDogInfo(results);
				if ("5".equals(groupStr)) {
					bigResultResp.setResult(results.getResultBbeBis());
				} else if ("6".equals(groupStr)) {
					bigResultResp.setResult(results.getResultOhcBis());
				} else {
					bigResultResp.setResult(results.getResultBis());
				}
				bigResultResp.setResult(results.getResultBig());
				group.getBigList().add(bigResultResp);
			}
			//添加全部成绩
			ShowResultDogInfo allResultResp = new ShowResultDogInfo(results);
			allResultResp.setAllResult(results);
			if (!StringUtils.isBlank(allResultResp.getResult()) && !StringUtils.isBlank(allResultResp.getName())) {
				group.getAllResultList().add(allResultResp);
			}
		});
		//重新排序
		response.getBisList().sort(Comparator.comparing(ShowResultDogInfo::getResult));
		response.getGroupList().forEach(showResultBreedGroup -> showResultBreedGroup.getBigList().sort(Comparator.comparing(ShowResultDogInfo::getResult)));
		return new RESTResponse("data", response);
	}
}
