/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.kennel.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.kennel.service.RestKennelService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 犬只信息管理Controller
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v1/kennel")
public class CkuKennelController extends BaseRestController {

	@Autowired
	private RestKennelService restKennelService;
	
	/**
	 *
	 * @description: CKU官网根据犬舍名称查询犬舍信息的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午4:11:11
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getByName(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.getByName(request,response);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "get", method = RequestMethod.GET)
	@ResponseBody
	public void get(String id, HttpServletRequest request, HttpServletResponse response) throws IOException{
		ServletUtils.writeResponse(response,restKennelService.getById(id));
	}

}
