package com.cku.restful.v1.groomer.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerShowService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 美容师活动Controller
 * 
 * @author cxt
 * @version 2016-07-14
 */
@Api(value = "美容活动报名-xuxue", tags = { "美容活动报名-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/groomer")
public class RestGroomerShowController extends BaseRestController {
	@Autowired
	private RestGroomerShowService restGroomerShowService;

	@ApiOperation(value = "美容活动报名-列表", notes = "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"list\": [\n" + "        {\n" + "            \"topicImage\": \"\",\n"
			+ "            \"showName\": \"2020年CKU华东区美容师资格认证考试\",\n"
			+ "            \"testLevel\": \"A/B/C\", -- 修改字段，当返回值有none时，返回\"\"\n" + "            \"fee\": \"300.00\",\n"
			+ "            \"reviewStateCode\": \"\",\n" + "            \"hotelId\": \"\",\n"
			+ "            \"referee\": \"\",\n" + "            \"showCode\": \"202004-青岛-ZG\",\n"
			+ "            \"showAddress\": \"青岛\",\n" + "            \"registerImage\": \"\",\n"
			+ "            \"reviewImage\": \"\",\n" + "            \"venueId\": \"\",\n"
			+ "            \"showType\": \"考试\",\n" + "            \"registerEndTime\": \"2020-06-12 15:00\",\n"
			+ "            \"startTime\": \"2020-06-06 00:00:00\",\n"
			+ "            \"endTime\": \"2020-06-06 00:00:00\",\n"
			+ "            \"id\": \"5f8278d05aef49f5b9b90111fb11b75d\",\n"
			+ "            \"canRegister\": true  -- 是否可以报名\n" + "        }\n" + "    ],\n" + "    \"total\": 47\n"
			+ "}\n" + ""))
	@RequestMapping(value = "/groomerShow", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerShowService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

}