/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.groomer.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import com.cku.logUtil.JSONObjectUtils;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.appreciation.dao.AppreciationApplyDao;
import com.cku.oa.appreciation.entity.AppreciationCertificate;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.handler.dao.HandlerDiplomaDao;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.cku.restful.v1.groomer.model.RestGroomerDiploma;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.utils.SortComparatorUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 美容师结业证书Service
 * 
 * @author cxt
 * @version 2016-07-15
 */
@Service
@Transactional(readOnly = true)
public class RestGroomerDiplomaService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME = "groomer_diploma@F";// 结业证书费

	@Autowired
	public GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private TrainingInstitutionService trainingInstitutionService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private HandlerDiplomaDao handlerDiplomaDao;
	@Autowired
	private HandlerQualificationCertificateDao handlerQualificationCertificateDao;
	@Autowired
	private AppreciationApplyDao appreciationApplyDao;

	/**
	 * 日志对象
	 */
	protected Logger logger = LoggerFactory.getLogger(getClass());

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		RestGroomerDiploma vo = BeanUtil.toBean(json, RestGroomerDiploma.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		GroomerDiploma po = buildPo(vo);
		// 业务校验
		groomerDiplomaService.validateBusiness(po);
		// 写入业务表
		groomerDiplomaService.save(po);
		// 写入购物车
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCartService.addToCart(paymentCart, "1049");
		return new RESTResponse("data", paymentCart.getId());
	}

	/**
	 * 
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(RestGroomerDiploma vo) {
		if (StringUtils.isBlank(vo.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		if (StringUtils.isBlank(vo.getStartDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间为空");
		}
		if (StringUtils.isBlank(vo.getEndDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "结束时间为空");
		}
		if (StringUtils.isBlank(vo.getTeacher())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训教师为空");
		}
		if (StringUtils.isBlank(vo.getCertificateLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书级别为空");
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			sdf.parse(vo.getStartDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间格式有误");
		}
		try {
			sdf.parse(vo.getEndDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "结束时间格式有误");
		}
		if (!"A".equals(vo.getCertificateLevel()) && !"B".equals(vo.getCertificateLevel())
				&& !"C".equals(vo.getCertificateLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书级别只能为A,B,C");
		}
	}

	/**
	 * 
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private GroomerDiploma buildPo(RestGroomerDiploma vo) {
		Member member = memberService.getByMemberCode(vo.getMemberCode());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
		}
		Member loginMember = UserUtils.getLoginMember();
		TrainingInstitution trainingInstitution = trainingInstitutionService
				.getByMemberCode(loginMember.getMemberCode());
		if (trainingInstitution == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前登录会员没有关联机构");
		}
		GroomerDiploma po = new GroomerDiploma();
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			po.setStartDate(sdf.parse(vo.getStartDate()));
			po.setEndDate(sdf.parse(vo.getEndDate()));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		po.setSchoolId(trainingInstitution.getId());
		po.setTeacher(vo.getTeacher());
		po.setCertificateLevel(vo.getCertificateLevel());
		po.setPaymentMemberCode(loginMember.getMemberCode());
		po.setPrintState("0");
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setSchoolNameEn(trainingInstitution.getSchoolNameEn());
		po.setSchoolNameCn(trainingInstitution.getSchoolNameCn());
		return po;
	}

	private PaymentCart buildPaymentCart(GroomerDiploma po) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME;
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("groomer_diploma");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	/**
	 * 批量提交列表
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日下午3:40:25
	 */
	public RESTResponse getList(HttpServletRequest request) {
		Member loginMember = UserUtils.getLoginMember();
		TrainingInstitution trainingInstitution = trainingInstitutionService
				.getByMemberCode(loginMember.getMemberCode());
		if (trainingInstitution == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前登录会员没有关联机构");
		}
		String schoolNameCn = trainingInstitution.getSchoolNameCn();
		// 获取参数
		String paymentState = request.getParameter("paymentState");
		String memberCode = request.getParameter("memberCode");
		String name = request.getParameter("name");
		String certificateLevel = request.getParameter("certificateLevel");
		String certificateCode = request.getParameter("certificateCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		GroomerDiploma groomerDiploma = new GroomerDiploma();
		// 设置分页参数
		Page<GroomerDiploma> page = new Page<GroomerDiploma>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		groomerDiploma.setSchoolNameCn(schoolNameCn);
		if (StringUtils.isNotBlank(paymentState)) {
			groomerDiploma.setPaymentState(paymentState);
		}
		if (StringUtils.isNotBlank(memberCode)) {
			groomerDiploma.setMemberCode(memberCode);
		}
		if (StringUtils.isNotBlank(name)) {
			groomerDiploma.setName(name);
		}
		if (StringUtils.isNotBlank(certificateLevel)) {
			groomerDiploma.setCertificateLevel(certificateLevel);
		}
		if (StringUtils.isNotBlank(certificateCode)) {
			groomerDiploma.setCertificateCode(certificateCode);
		}
		groomerDiploma.setDelFlag("0");
		groomerDiploma.setPage(page);
		List<GroomerDiploma> findList = groomerDiplomaService.findList(groomerDiploma);
		List<RestGroomerDiploma> list = new ArrayList<RestGroomerDiploma>();
		for (GroomerDiploma gd : findList) {
			RestGroomerDiploma vo = new RestGroomerDiploma();
			BeanUtil.copyProperties(vo, gd, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			list.add(vo);
		}
		long count = list.size();
		return new RESTResponse("list", new PageBeanResult<RestGroomerDiploma>(list, count));
	}

	/**
	 * 删除
	 * 
	 * @Author chaixueteng
	 * @2016年9月27日下午1:31:31
	 */
	public RESTResponse delete(String id) {
		GroomerDiploma groomerDiploma = groomerDiplomaService.get(id);
		if (groomerDiploma == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		groomerDiplomaService.delete(groomerDiploma);
		return new RESTResponse();
	}

	@Autowired
	private GroomerDiplomaDao groomerDiplomaDao;

	/**
	 * 
	 * @description: CKU官网美容结业证书查询
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午7:58:29
	 */
	public RESTResponse getByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "key为空");
		}
		GroomerDiploma groomerDiploma = new GroomerDiploma();
		GroomerDiploma po = groomerDiplomaDao.getByKey(key).get(0);
		RestGroomerDiploma vo = null;
		if (po != null) {
			vo = new RestGroomerDiploma();
			Member member = memberService.getByMemberCode(po.getMemberCode());
			if (StringUtils.isBlank(member.getGroomerType()) || member.getGroomerEndDate() == null
					|| new Date().after(member.getGroomerEndDate())) {
				groomerDiploma.setMemberCode("会员信息无效");
			} else {
				groomerDiploma = po;
			}
			BeanUtil.copyProperties(vo, groomerDiploma, "yyyy-MM-dd");
		}
		return new RESTResponse("data", vo);
	}

	/**
	 * CKU官网查询美容及结业信息(证书号/会员号)
	 * 
	 * @Author chaixueteng
	 * @2017年7月4日下午3:13:52
	 */
	public RESTResponse getGroomerAndHandlerMsgByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "key为空");
		}
		List<Map<String, String>> msgList = new ArrayList<Map<String, String>>();
		// 美容结业证书
		List<GroomerDiploma> gdList = groomerDiplomaDao.getByKey(key);
		logger.info("-------美容结业证书------- gdList : {}", JSONObjectUtils.toJsonString(gdList));
		if (gdList.size() > 0) {
			for (GroomerDiploma groomerDiploma : gdList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "美容师结业证书");
				map.put("memberCode", groomerDiploma.getMemberCode());
				map.put("name", groomerDiploma.getName());
				map.put("level", groomerDiploma.getCertificateLevel());
				map.put("certificateCode", groomerDiploma.getCertificateCode());
				if (groomerDiploma.getIssueDate() != null) {
					map.put("issDate", DateUtils.formatDate(groomerDiploma.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", groomerDiploma.getSchoolNameCn());
				msgList.add(map);
			}
		}
		// 牵犬师 结业证书
		List<HandlerDiploma> hdList = handlerDiplomaDao.getByKey(key, "0");
		logger.info("-------牵犬师 结业证书------- hdList : {}", JSONObjectUtils.toJsonString(hdList));
		if (hdList.size() > 0) {
			for (HandlerDiploma handlerDiploma : hdList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "牵犬师结业证书");
				map.put("memberCode", handlerDiploma.getMemberCode());
				map.put("name", handlerDiploma.getName());
				map.put("level", handlerDiploma.getCertificateLevel());
				map.put("certificateCode", handlerDiploma.getCertificateCode());
				if (handlerDiploma.getIssueDate() != null) {
					map.put("issDate", DateUtils.formatDate(handlerDiploma.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", handlerDiploma.getSchoolNameCn());
				msgList.add(map);
			}
		}
		// 训犬师 结业证书
		List<HandlerDiploma> tdList = handlerDiplomaDao.getByKey(key, "1");
		logger.info("-------训犬师 结业证书------- tdList : {}", JSONObjectUtils.toJsonString(tdList));
		if (tdList.size() > 0) {
			for (HandlerDiploma handlerDiploma : tdList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "训犬师结业证书");
				map.put("memberCode", handlerDiploma.getMemberCode());
				map.put("name", handlerDiploma.getName());
				map.put("level", handlerDiploma.getCertificateLevel());
				map.put("certificateCode", handlerDiploma.getCertificateCode());
				if (handlerDiploma.getIssueDate() != null) {
					map.put("issDate", DateUtils.formatDate(handlerDiploma.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", handlerDiploma.getSchoolNameCn());
				map.put("identificationFlag",
						handlerDiploma.getIdentificationFlag() == null ? "" : handlerDiploma.getIdentificationFlag());
				msgList.add(map);
			}
		}

		List<GroomerQualificationCertificate> qualificationCertificates = groomerQualificationCertificateDao.getByKeyNew(key);
		if (CollectionUtils.isNotEmpty(qualificationCertificates)) {
			for (GroomerQualificationCertificate groomerQualificationCertificate : qualificationCertificates) {
				Map<String, String> map = new HashMap<String, String>();
				String certificateType = groomerQualificationCertificate.getCertificateType();
				if ("3".equals(certificateType)) {
					map.put("top", "宠物造型师资格证书");
				} else if ("2".equals(certificateType)) {
					map.put("top", "国际宠物美容师资格证书");
				} else if ("4".equals(certificateType)) {
					map.put("top", "CKU国际宠物洗护师");
				} else if ("1".equals(certificateType)) {
					map.put("top", "美容师资格证书");
				} else if ("6".equals(certificateType)) {
					map.put("top", "派多格资格证书");
				} else if ("7".equals(certificateType)) {
					map.put("top", "FCI美容师资格认证");
				} else if ("8".equals(certificateType)) {
					map.put("top", "伴侣猫洗护师资格证书");
				}
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				String levelCn = groomerQualificationCertificate.getLevelCn();
				if ("4".equals(certificateType)) {
					map.put("level", DictUtils.getDictLabel(levelCn, "groomer_nurse_level", null));
				} else {
					map.put("level", levelCn);
				}
				if(groomerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}
		/*// 美容资格证书
		List<GroomerQualificationCertificate> gqcList = groomerQualificationCertificateDao.getByKey(key);
		logger.info("-------美容资格证书------- gqcList : {}", JSONObjectUtils.toJsonString(gqcList));
		if (gqcList.size() > 0) {
			for (GroomerQualificationCertificate groomerQualificationCertificate : gqcList) {
				Map<String, String> map = new HashMap<String, String>();
				if (Objects.equals(groomerQualificationCertificate.getCertificateType(), "6")) {
					map.put("top", "派多格资格证书");
				} else {
					map.put("top", "美容师资格证书");
				}
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				String levelEn = groomerQualificationCertificate.getLevelEn();
				if ("MASTER".equals(levelEn.trim())) {
					map.put("level", "教师级");
				} else {
					map.put("level", levelEn);
				}
				if (groomerQualificationCertificate.getIssueDate() != null) {
					map.put("issDate",
							DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			}
		}
		// 国际宠物洗护师证书
		List<GroomerQualificationCertificate> gjxhsList = groomerQualificationCertificateDao.getNurseByKey(key);
		logger.info("-------国际宠物洗护师证书------- gjxhsList : {}", JSONObjectUtils.toJsonString(gjxhsList));
		if (gjxhsList.size() > 0) {
			for (GroomerQualificationCertificate groomerQualificationCertificate : gjxhsList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "国际宠物洗护师证书");
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				map.put("level", GroomerUtil.getLevelCn(groomerQualificationCertificate.getLevelEn().trim()));
				if (groomerQualificationCertificate.getIssueDate() != null) {
					map.put("issDate",
							DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			}
		}*/
		// 牵犬师资格证书
		List<HandlerQualificationCertificate> hqcList = handlerQualificationCertificateDao.getByKey(key);
		logger.info("-------牵犬师资格证书------- hqcList : {}", JSONObjectUtils.toJsonString(hqcList));
		if (hqcList.size() > 0) {
			for (HandlerQualificationCertificate handlerQualificationCertificate : hqcList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "牵犬师资格证书");
				map.put("memberCode", handlerQualificationCertificate.getMemberCode());
				map.put("name", handlerQualificationCertificate.getName());
				map.put("certificateCode", handlerQualificationCertificate.getCertificateCode());
				String levelEn = handlerQualificationCertificate.getCertificateLevelEn();
				if ("MASTER".equals(levelEn.trim())) {
					map.put("level", "教师级");
				} else {
					map.put("level", levelEn);
				}
				if (handlerQualificationCertificate.getIssueDate() != null) {
					map.put("issDate",
							DateUtils.formatDate(handlerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			}
		}

		// 训练师资格证书
		List<HandlerQualificationCertificate> hqcTrainerList = handlerQualificationCertificateDao.getHandlerTrainerByKey(key);
		logger.info("-------训练师资格证书------- hqcList : {}", JSONObjectUtils.toJsonString(hqcTrainerList));
		if (hqcTrainerList.size() > 0) {
			for (HandlerQualificationCertificate handlerQualificationCertificate : hqcTrainerList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "训练师资格证书");
				map.put("memberCode", handlerQualificationCertificate.getMemberCode());
				map.put("name", handlerQualificationCertificate.getName());
				map.put("certificateCode", handlerQualificationCertificate.getCertificateCode());
				String levelEn = handlerQualificationCertificate.getCertificateLevelEn();
				if ("MASTER".equals(levelEn.trim())) {
					map.put("level", "教师级");
				} else {
					map.put("level", levelEn);
				}
				if (handlerQualificationCertificate.getIssueDate() != null) {
					map.put("issDate",
							DateUtils.formatDate(handlerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			}
		}

		// 鉴赏课程证书
		List<AppreciationCertificate> certificateList = appreciationApplyDao.getByMemberCodeOrCertificateCode(key, key);
		logger.info("-------鉴赏课程证书------- certificateList : {}", JSONObjectUtils.toJsonString(certificateList));
		if (msgList.size() > 0) {
			String memberCode = msgList.get(0).get("memberCode");
			Member member = memberService.getByMemberCode(memberCode);
			if (!MemberUtil.isActiveMember(member)) {
				if(CollectionUtils.isEmpty(certificateList)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息无效!");
				}else {
					msgList.clear();
				}
			}
		}
		
		if (CollectionUtils.isNotEmpty(certificateList)) {
			certificateList.forEach(ac -> {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "鉴赏课程证书");
				map.put("memberCode", ac.getMemberCode());
				map.put("name", ac.getMemberName());
				map.put("courseName", ac.getCourseName());
				map.put("certificateCode", ac.getCertificateCode());
				if (ac.getIssueDate() != null) {
					map.put("issDate", DateUtils.formatDate(ac.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			});
		}
		SortComparatorUtil sortComparatorUtil = new SortComparatorUtil();
		Collections.sort(msgList, sortComparatorUtil);
		return new RESTResponse("list", msgList);
	}

}