package com.cku.restful.v1.finance.service;

import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogDnaParentsCompareDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.thinkgem.jeesite.common.utils.StringUtils;

@Service
@Transactional(readOnly = true)
public class DogChipDeleteService {

	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogBloodSaveDao dogBloodSaveDao;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	private DogDnaParentsCompareDao dogDnaParentsCompareDao;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;

	/**
	 * 整窝删除业务
	 *
	 * @param businessid
	 */
	public void deleteDogChipDogBirthCertificate(String businessid) {
		DogChip dogChip = dogChipDao.getByFmdogBreedCertifiedCode(businessid);
		if (dogChip != null && "1".equals(dogChip.getIsAll())) {
			dogChipDao.deleteDogChipDogBirthCertificate(
					"UPDATE dog_chip SET del_flag = '1' WHERE fmdog_breed_certified_code = '" + businessid + "'  ;");
			dogChipDao.deleteDogChipDogBirthCertificate(
					"UPDATE dog_birth_certificate SET del_flag = '1' WHERE fmdog_breed_certified_code = '" + businessid + "';");
			dogChipDao.deleteDogChipDogBirthCertificate(
					"UPDATE dog_blood_save SET del_flag = '1' WHERE fmdog_breed_certified_code = '" + businessid + "';");
			// dogChipDao.deleteDogChipDogBirthCertificate(
			// "delete from dog_dna_archive WHERE fmdog_breed_certified_code = '" +
			// businessid + "';");
			// dogChipDao.deleteDogChipDogBirthCertificate(
			// "delete from dog_dna_parents_compare WHERE fmdog_breed_certified_code = '" +
			// businessid + "';");
		}
	}

	/**
	 * @description: 血统证书业务删除时需要情况新生犬登记卡的addUser字段
	 * @author: laiguanglong
	 * @date: 2017/6/2 15:30
	 */
	public void deleteDogBirthCertificateAddUser(String tableName, String businessIds) {
		if ("dog_chip".equals(tableName)) {
			DogChip dogChip = dogChipDao.get(businessIds);
			if (dogChip == null)// 整窝删除业务
			{
				deleteDogChipDogBirthCertificate(businessIds);
				return;
			}
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByBirthCerRegCode(dogChip.getBirthCode());
			if (StringUtils.isNotBlank(dogBirthCertificate.getAddUser())) {
				dogBirthCertificate.setAddUser(null);
				dogBirthCertificateDao.update(dogBirthCertificate);
			}
		}
	}

	/**
	 * @description: 购物车血统证书业务删除时需要情况新生犬登记卡的addUser字段
	 * @author: laiguanglong
	 * @date: 2017/6/2 15:30
	 */
	public void deleteCartDogBirthCertificateAddUser(String tableName, String businessIds) {
		String birthCode = "";
		if ("dog_chip".equals(tableName)) {
			DogChip dogChip = dogChipDao.get(businessIds);
			if (dogChip == null) {// 整窝删除业务
				deleteDogChipDogBirthCertificate(businessIds);
				return;
			}
			if (dogChip != null && StringUtils.isNotBlank(dogChip.getBirthCode())) {
				birthCode = dogChip.getBirthCode();
			}
		} else if ("dog_blood_save".equals(tableName)) {
			DogBloodSave dogBloodSave = dogBloodSaveDao.get(businessIds);
			if (dogBloodSave != null && StringUtils.isNotBlank(dogBloodSave.getBirthCode())) {
				birthCode = dogBloodSave.getBirthCode();
			}
		} else if ("dog_dna_archive".equals(tableName)) {
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.get(businessIds);
			if (dogDnaArchive != null && StringUtils.isNotBlank(dogDnaArchive.getBirthCode())) {
				birthCode = dogDnaArchive.getBirthCode();
			}
		} else if ("dog_dna_parents_compare".equals(tableName)) {
			DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareDao.get(businessIds);
			if (dogDnaParentsCompare != null && StringUtils.isNotBlank(dogDnaParentsCompare.getBirthCode())) {
				birthCode = dogDnaParentsCompare.getBirthCode();
			}
		}
		if (StringUtils.isNotBlank(birthCode)) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
			// 解决合作机构办理完血统证书，会员再次申请以上相关业务后，清除购物车数据时，导致血统证书无法在俱乐部打印问题
			// 增加是否已经办理血统证书判断，如已办理则不清除ADD_USER字段
			DogChip dogChip = dogChipDao.getByBirthCode(birthCode);
			boolean clearFlag = Boolean.TRUE;
			if (Objects.nonNull(dogChip) || StringUtils.isNotBlank(dogBirthCertificate.getPedigreeCertified())) {
				clearFlag = Boolean.FALSE;
			}
			if (StringUtils.isNotBlank(dogBirthCertificate.getAddUser()) && clearFlag) {
				dogBirthCertificate.setAddUser(null);
				dogBirthCertificateDao.update(dogBirthCertificate);
			}
		}
		
		dogChipDao.deleteDogChipDogBirthCertificate(
				"UPDATE " + tableName +   "  SET del_flag = '1' WHERE id = '" + businessIds + "';");
	}
}