package com.cku.restful.v1.dog.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogTibetanMastiffDao;
import com.cku.oa.dog.entity.DogTibetanMastiff;
import com.cku.oa.dog.service.DogTibetanMastiffService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dog.model.RestDogTibetanMastiff;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 藏獒犬只鉴定Service
 * @author zhuoHeng
 * @version 2016-08-24
 */
@Service
@Transactional(readOnly = true)
public class RestDogTibetanMastiffService {

	@Autowired
	private DogTibetanMastiffDao dogTibetanMastiffDao;
	@Autowired
	private DogTibetanMastiffService dogTibetanMastiffService;
	
	public RESTResponse getList(HttpServletRequest request){
		Member member = UserUtils.getLoginMember();
		//获取参数
		String dogName = request.getParameter("dogName");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		
		//参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if(StringUtils.isNotBlank(pageNo)){
				pageNoInt = Integer.parseInt(pageNo);
			}
			if(StringUtils.isNotBlank(pageSize)){
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"pageNo和pageSize必须都为数字");
		}
		
		DogTibetanMastiff example = new DogTibetanMastiff();
		//设置分页参数
		Page<DogTibetanMastiff> page = new Page<DogTibetanMastiff>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		//设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if(StringUtils.isNotBlank(dogName)){
			example.setDogName(dogName);
		}
		//查询并组装返回对象
		Page<DogTibetanMastiff> result = dogTibetanMastiffService.findPage(page, example);
		List<DogTibetanMastiff> dogTibetanMastiffList = result.getList();
		List<RestDogTibetanMastiff> list = new ArrayList<RestDogTibetanMastiff>();
		for(DogTibetanMastiff dogTibetanMastiff:dogTibetanMastiffList){
			RestDogTibetanMastiff vo = new RestDogTibetanMastiff();
			BeanUtil.copyProperties(vo, dogTibetanMastiff, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			list.add(vo);
		}
		return new RESTResponse("list",new PageBeanResult<RestDogTibetanMastiff>(list,result.getCount()));
	}
	
	@Transactional(readOnly = false)
	public RESTResponse delete(String id){
		Member member = UserUtils.getLoginMember();
		DogTibetanMastiff po = dogTibetanMastiffService.get(id);
		if(po==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"id有误");
		}
		if(!member.getMemberCode().equals(po.getMemberCode())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"id有误");
		}
		dogTibetanMastiffService.delete(po);
		//delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}
	
	@Transactional(readOnly = false)
	public RESTResponse post(String json){
		Member member = UserUtils.getLoginMember();
		//获取参数
		RestDogTibetanMastiff vo = BeanUtil.toBean(json, RestDogTibetanMastiff.class);
		//参数校验
		Date birthdate = validateParameter(vo);
		//TODO:业务校验
		validateBusiness();
		//写入业务表
		insertBusinessTable(vo, birthdate, member);

		//delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}
	/**
	 * 
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:12:34
	 */
	private Date validateParameter(RestDogTibetanMastiff vo){
		if(StringUtils.isBlank(vo.getDogName())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬名为空");
		}
		if(StringUtils.isBlank(vo.getBirthdate())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"出生日期为空");
		}
		if(StringUtils.isBlank(vo.getGender())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬性别为空");
		}
		if(StringUtils.isBlank(vo.getColorFlag())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬毛色为空");
		}
		if(!"1".equals(vo.getGender())&&!"2".equals(vo.getGender())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬性别有误");
		}
		Date birthdate = null;
		try {
			birthdate = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBirthdate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"出生日期格式有误");
		}
		return birthdate;
	}
	/**
	 * 
	 * @description: 写入业务表
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:18:01
	 */
	private void insertBusinessTable(RestDogTibetanMastiff vo,Date birthdate,Member member){
		DogTibetanMastiff dogTibetanMastiff = new DogTibetanMastiff();
		dogTibetanMastiff.setDogName(vo.getDogName());
		dogTibetanMastiff.setBirthdate(birthdate);
		dogTibetanMastiff.setGender(vo.getGender());
		dogTibetanMastiff.setColorFlag(vo.getColorFlag());
		dogTibetanMastiff.setDogOwner(member.getName());
		dogTibetanMastiff.setMemberCode(member.getMemberCode());
		dogTibetanMastiffService.add(dogTibetanMastiff);
	}
	/**
	 * 
	 * @description: 业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:57:04
	 */
	private void validateBusiness(){
		
	}
	
}