/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.restful.v1.dog.model.RestDogColorMark;
import com.cku.restful.v1.sys.utils.BeanUtil;

/**
 * 犬只颜色及标志Service
 * @author lgl
 * @version 2016-08-05
 */
@Service
@Transactional(readOnly = true)
public class RestDogColorMarkService {

	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;

	/**
	 * 
	 * @description: 根据犬种获取毛色列表
	 * @author: laiguanglong
	 * @date: 2016年9月7日 下午5:07:07
	 */
	public RESTResponse getList(String dogBreed) {
		if (StringUtils.isBlank(dogBreed)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种号为空");
		}
		List<RestDogColorMark> list = new ArrayList<RestDogColorMark>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
		if (dogType == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种号有误");
		}
		if (StringUtils.isNotBlank(dogType.getDogColor())) {
			for (String dogColor : dogType.getDogColor().split(",")) {
				DogColorMark dogColorMark = dogColorMarkService
						.getByDogColorMarkCode(dogColor);
				if (dogColorMark != null) {
					RestDogColorMark vo = new RestDogColorMark();
					BeanUtil.copyProperties(vo, dogColorMark, "yyyy-MM-dd");
					list.add(vo);
				}
			}
		}else{
			List<DogColorMark> dogColorMarkList = dogColorMarkService.findAllList();
			for(DogColorMark dogColorMark:dogColorMarkList){
				RestDogColorMark vo = new RestDogColorMark();
				BeanUtil.copyProperties(vo, dogColorMark, "yyyy-MM-dd");
				list.add(vo);
			}
		}
		// 封装数据返回
		return new RESTResponse("list", new PageBeanResult<RestDogColorMark>(
				list, (long) list.size()));
	}

}