/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.restful.v1.dog.service.RestDogStickerApplyService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional(readOnly = true)
public class BreederDogStickerApplyService {
    @Autowired
    private RestDogStickerApplyService restDogStickerApplyService;
    @Autowired
    private RestOrderService restOrderService;
    @Autowired
    private PaymentOrderDao paymentOrderDao;
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private PaymentChargingItemService paymentChargingItemService;

    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        RESTResponse response = restDogStickerApplyService.post(json);
        String[] cardIds = new String[]{response.getData().getJSONObject("data").getString("cartIds")};
        return restOrderService.cartToOrder(cardIds);
    }

    public RESTResponse order(String id) {
        String memberCode = UserUtils.getLoginMember().getMemberCode();
        PaymentOrder paymentOrder = paymentOrderDao.get(id);
        if (paymentOrder == null || !paymentOrder.getMemberCode().equals(memberCode)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号有误");
        }
        PaymentOrderDetail detail = null;
        List<PaymentOrderDetail> paymentOrderDetailList = paymentOrderDetailDao.getOrderByRunningNum(paymentOrder.getOrderCode(), memberCode);
        for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
            if ("dog_sticker_apply".equals(paymentOrderDetail.getBusinessTable())) {
                detail = paymentOrderDetail;
                break;
            }
        }
        //组装返回对象
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(detail.getChargingItemId());
        JSONObject jo = new JSONObject();
        jo.put("orderCode", paymentOrder.getOrderCode());
        jo.put("totalPrice", paymentOrder.getTotalPrice());
        jo.put("productName", paymentChargingItem.getName());
        jo.put("productPrice", paymentChargingItem.getPrice());
        return new RESTResponse("data", jo);
    }

}