package com.cku.partner.sys.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class PartnerLoginUserInfo implements Serializable {

	private static final long serialVersionUID = 2421445564208085729L;

	@ApiModelProperty("机构ID")
	@NotEmpty(message = "机构ID不能为空")
	private String id;
	
	@ApiModelProperty("关联账户ID")
	private String userId;
	
	@ApiModelProperty("关联会员号")
	private String memberCode;
	
	@ApiModelProperty("机构名称")
	private String name;

	@ApiModelProperty("机构类型 （club：地方俱乐部，hospital：合作医院，catRenZheng：国际纯种犬猫认证服务中心，singleTypeClub：单犬种俱乐部，chongjihemendian：宠集盒门店）")
	private String type;
	
	@ApiModelProperty("联系人姓名")
	private String contactName;
	
	@ApiModelProperty("联系电话")
	private String contactTel;
	
	@ApiModelProperty("账户余额")
	private BigDecimal accountBalance;

	@ApiModelProperty("地址信息")
	private PartnerAddress address;
	
	@ApiModelProperty("截止日期")
	private Date endDate;

	@ApiModelProperty("押金")
	private BigDecimal deposit;
	
	@ApiModelProperty("推荐人")
	private String tuijianren;
	
}
