package com.cku.oa.timedtask.service;

import java.util.List;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sys.dao.TaskTriggerDao;
import com.cku.oa.sys.entity.TaskTrigger;
import com.cku.oa.sys.service.ChangeTimeService;

public class WebContextListener implements ServletContextListener{

	@Autowired
	private TaskTriggerDao taskTriggerDao;
	@Override
	public void contextInitialized(ServletContextEvent sce) {
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			List<TaskTrigger> list = taskTriggerDao.findAll();
			SchedulerFactory factory = new StdSchedulerFactory();
			StdScheduler scheduler = (StdScheduler) factory.getScheduler();
			JobDetail jobDetail = null;
			for (TaskTrigger sysTask: list) {
				jobDetail = scheduler.getJobDetail(JobKey.jobKey(sysTask.getJobName(), sysTask.getJobGroup()));
				if(jobDetail == null){
					ChangeTimeService.addJob(scheduler, sysTask.getJobName(), sysTask.getJobGroup(), sysTask.getJobName(), 
							"EXTJWEB_TRIGGERGROUP_NAME", Class.forName(sysTask.getJobCls()), sysTask.getTimeFormat(),sysTask.getJobInfo());
				}
			}
		} catch (SchedulerException | ClassNotFoundException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		// TODO Auto-generated method stub
	}

}
