package com.cku.oa.timedtask.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.handler.service.HandlerQualificationCertificateService;

@Service
@Transactional(readOnly = true)
public class HandlerQualificationCertificateTask extends JobActingService{

	@Autowired
	private HandlerQualificationCertificateService handlerQualificationCertificateService;
	
	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			count = handlerQualificationCertificateService.deleteQualificationCertificate();
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}

	@Override
	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			count = handlerQualificationCertificateService.deleteQualificationCertificate();
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}
	
	

}
